/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.targetdriverdialect;

import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.targetdriverdialect.GenericTargetDriverDialect;
import software.amazon.jdbc.targetdriverdialect.MysqlConnectorJDataSourceHelper;

public class MysqlConnectorJTargetDriverDialect
extends GenericTargetDriverDialect {
    private static final String DRIVER_CLASS_NAME = "com.mysql.cj.jdbc.Driver";
    private static final String DS_CLASS_NAME = "com.mysql.cj.jdbc.MysqlDataSource";
    private static final String CP_DS_CLASS_NAME = "com.mysql.cj.jdbc.MysqlConnectionPoolDataSource";

    @Override
    public boolean isDialect(Driver driver) {
        return DRIVER_CLASS_NAME.equals(driver.getClass().getName());
    }

    @Override
    public boolean isDialect(String dataSourceClass) {
        return DS_CLASS_NAME.equals(dataSourceClass) || CP_DS_CLASS_NAME.equals(dataSourceClass);
    }

    @Override
    public void prepareDataSource(@NonNull DataSource dataSource, @NonNull String protocol, @NonNull HostSpec hostSpec, @NonNull Properties props) throws SQLException {
        MysqlConnectorJDataSourceHelper helper = new MysqlConnectorJDataSourceHelper();
        helper.prepareDataSource(dataSource, hostSpec, props);
    }
}

