/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.plugin;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.JdbcCallable;
import software.amazon.jdbc.plugin.AbstractConnectionPlugin;
import software.amazon.jdbc.util.Messages;

public class ConnectTimeConnectionPlugin
extends AbstractConnectionPlugin {
    private static final Set<String> subscribedMethods = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("connect", "forceConnect")));
    private static long connectTime = 0L;
    private static final Logger LOGGER = Logger.getLogger(ConnectTimeConnectionPlugin.class.getName());

    @Override
    public Set<String> getSubscribedMethods() {
        return subscribedMethods;
    }

    @Override
    public Connection connect(String driverProtocol, HostSpec hostSpec, Properties props, boolean isInitialConnection, JdbcCallable<Connection, SQLException> connectFunc) throws SQLException {
        long startTime = System.nanoTime();
        Connection result = connectFunc.call();
        long elapsedTimeNanos = System.nanoTime() - startTime;
        connectTime += elapsedTimeNanos;
        LOGGER.fine(() -> Messages.get("ConnectTimeConnectionPlugin.connectTime", new Object[]{elapsedTimeNanos}));
        return result;
    }

    @Override
    public Connection forceConnect(String driverProtocol, HostSpec hostSpec, Properties props, boolean isInitialConnection, JdbcCallable<Connection, SQLException> forceConnectFunc) throws SQLException {
        long startTime = System.nanoTime();
        Connection result = forceConnectFunc.call();
        long elapsedTimeNanos = System.nanoTime() - startTime;
        LOGGER.fine(() -> Messages.get("ConnectTimeConnectionPlugin.connectTime", new Object[]{elapsedTimeNanos}));
        connectTime += elapsedTimeNanos;
        return result;
    }

    public static void resetConnectTime() {
        connectTime = 0L;
    }

    public static long getTotalConnectTime() {
        return connectTime;
    }
}

