/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.Nullable;

public class StringUtils {
    private static final String ENCODING_FOR_URL = System.getProperty("software.amazon.jdbc.Driver.url.encoding", "UTF-8");

    public static String decode(String encoded) {
        try {
            return URLDecoder.decode(encoded, ENCODING_FOR_URL);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Unable to decode URL entry via " + ENCODING_FOR_URL + ". This should not happen", e);
        }
    }

    public static String encode(String plain) {
        try {
            return URLEncoder.encode(plain, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Unable to encode URL entry via " + ENCODING_FOR_URL + ". This should not happen", e);
        }
    }

    @EnsuresNonNullIf(expression={"#1"}, result=false)
    public static boolean isNullOrEmpty(@Nullable String s) {
        return s == null || s.equals("");
    }

    public static List<String> split(String stringToSplit, String delimiter, boolean trim) {
        if (stringToSplit == null || "".equals(stringToSplit)) {
            return new ArrayList<String>();
        }
        if (delimiter == null) {
            throw new IllegalArgumentException();
        }
        String[] tokens = stringToSplit.split(delimiter, -1);
        Stream<String> tokensStream = Arrays.stream(tokens);
        if (trim) {
            tokensStream = tokensStream.map(String::trim);
        }
        return tokensStream.filter(x -> x != null && !"".equals(x)).collect(Collectors.toList());
    }
}

