/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.dialect;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import software.amazon.jdbc.dialect.MysqlDialect;
import software.amazon.jdbc.dialect.TopologyAwareDatabaseCluster;

public class AuroraMysqlDialect
extends MysqlDialect
implements TopologyAwareDatabaseCluster {
    @Override
    public String getTopologyQuery() {
        return "SELECT SERVER_ID, CASE WHEN SESSION_ID = 'MASTER_SESSION_ID' THEN TRUE ELSE FALSE END, CPU, REPLICA_LAG_IN_MILLISECONDS, LAST_UPDATE_TIMESTAMP FROM information_schema.replica_host_status WHERE time_to_sec(timediff(now(), LAST_UPDATE_TIMESTAMP)) <= 300 OR SESSION_ID = 'MASTER_SESSION_ID' ";
    }

    @Override
    public String getNodeIdQuery() {
        return "SELECT @@aurora_server_id";
    }

    @Override
    public String getIsReaderQuery() {
        return "SELECT @@innodb_read_only";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isDialect(Connection connection) {
        try (Statement stmt = connection.createStatement();
             ResultSet rs = stmt.executeQuery("SHOW VARIABLES LIKE 'aurora_version'");){
            if (!rs.next()) return false;
            boolean bl = true;
            return bl;
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public List<String> getDialectUpdateCandidates() {
        return null;
    }
}

