/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import software.amazon.jdbc.ConnectionPlugin;
import software.amazon.jdbc.ConnectionPluginManager;
import software.amazon.jdbc.HostAvailability;
import software.amazon.jdbc.HostListProvider;
import software.amazon.jdbc.HostListProviderService;
import software.amazon.jdbc.HostRole;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.NodeChangeOptions;
import software.amazon.jdbc.OldConnectionSuggestedAction;
import software.amazon.jdbc.PluginManagerService;
import software.amazon.jdbc.PluginService;
import software.amazon.jdbc.cleanup.CanReleaseResources;
import software.amazon.jdbc.dialect.Dialect;
import software.amazon.jdbc.dialect.DialectManager;
import software.amazon.jdbc.dialect.DialectProvider;
import software.amazon.jdbc.exceptions.ExceptionManager;
import software.amazon.jdbc.hostlistprovider.StaticHostListProvider;
import software.amazon.jdbc.util.CacheMap;
import software.amazon.jdbc.util.Messages;

public class PluginServiceImpl
implements PluginService,
CanReleaseResources,
HostListProviderService,
PluginManagerService {
    private static final Logger LOGGER = Logger.getLogger(PluginServiceImpl.class.getName());
    protected static final long DEFAULT_HOST_AVAILABILITY_CACHE_EXPIRE_NANO = TimeUnit.MINUTES.toNanos(5L);
    protected static final CacheMap<String, HostAvailability> hostAvailabilityExpiringCache = new CacheMap();
    protected final ConnectionPluginManager pluginManager;
    private final Properties props;
    private final String originalUrl;
    private final String driverProtocol;
    protected volatile HostListProvider hostListProvider;
    protected List<HostSpec> hosts = new ArrayList<HostSpec>();
    protected Connection currentConnection;
    protected HostSpec currentHostSpec;
    protected HostSpec initialConnectionHostSpec;
    private boolean isInTransaction;
    private boolean explicitReadOnly;
    private final ExceptionManager exceptionManager;
    protected final DialectProvider dialectProvider;
    protected Dialect dialect;

    public PluginServiceImpl(@NonNull ConnectionPluginManager pluginManager, @NonNull Properties props, @NonNull String originalUrl, String targetDriverProtocol) throws SQLException {
        this(pluginManager, new ExceptionManager(), props, originalUrl, targetDriverProtocol, new DialectManager());
    }

    public PluginServiceImpl(@NonNull ConnectionPluginManager pluginManager, @NonNull ExceptionManager exceptionManager, @NonNull Properties props, @NonNull String originalUrl, String targetDriverProtocol, @NonNull DialectProvider dialectProvider) throws SQLException {
        this.pluginManager = pluginManager;
        this.props = props;
        this.originalUrl = originalUrl;
        this.driverProtocol = targetDriverProtocol;
        this.exceptionManager = exceptionManager;
        this.dialectProvider = dialectProvider;
        this.dialect = this.dialectProvider.getDialect(this.driverProtocol, this.originalUrl, this.props);
    }

    @Override
    public Connection getCurrentConnection() {
        return this.currentConnection;
    }

    @Override
    public HostSpec getCurrentHostSpec() {
        if (this.currentHostSpec == null) {
            this.currentHostSpec = this.initialConnectionHostSpec;
            if (this.currentHostSpec == null) {
                if (this.getHosts().isEmpty()) {
                    throw new RuntimeException(Messages.get("PluginServiceImpl.hostListEmpty"));
                }
                this.currentHostSpec = this.getWriter(this.getHosts());
                if (this.currentHostSpec == null) {
                    this.currentHostSpec = this.getHosts().get(0);
                }
            }
            if (this.currentHostSpec == null) {
                throw new RuntimeException("Current host is undefined.");
            }
            LOGGER.finest(() -> "Set current host to " + this.currentHostSpec);
        }
        return this.currentHostSpec;
    }

    @Override
    public void setInitialConnectionHostSpec(@NonNull HostSpec initialConnectionHostSpec) {
        this.initialConnectionHostSpec = initialConnectionHostSpec;
    }

    @Override
    public HostSpec getInitialConnectionHostSpec() {
        return this.initialConnectionHostSpec;
    }

    @Override
    public boolean acceptsStrategy(HostRole role, String strategy) throws SQLException {
        return this.pluginManager.acceptsStrategy(role, strategy);
    }

    @Override
    public HostSpec getHostSpecByStrategy(HostRole role, String strategy) throws SQLException {
        return this.pluginManager.getHostSpecByStrategy(role, strategy);
    }

    @Override
    public HostRole getHostRole(Connection conn) throws SQLException {
        return this.hostListProvider.getHostRole(conn);
    }

    private HostSpec getWriter(@NonNull List<HostSpec> hosts) {
        for (HostSpec hostSpec : hosts) {
            if (hostSpec.getRole() != HostRole.WRITER) continue;
            return hostSpec;
        }
        return null;
    }

    @Override
    public void setCurrentConnection(@NonNull Connection connection, @NonNull HostSpec hostSpec) throws SQLException {
        this.setCurrentConnection(connection, hostSpec, null);
    }

    @Override
    public synchronized EnumSet<NodeChangeOptions> setCurrentConnection(@NonNull Connection connection, @NonNull HostSpec hostSpec, @Nullable ConnectionPlugin skipNotificationForThisPlugin) throws SQLException {
        if (this.currentConnection == null) {
            this.currentConnection = connection;
            this.currentHostSpec = hostSpec;
            EnumSet<NodeChangeOptions> changes = EnumSet.of(NodeChangeOptions.INITIAL_CONNECTION);
            this.pluginManager.notifyConnectionChanged(changes, skipNotificationForThisPlugin);
            return changes;
        }
        EnumSet<NodeChangeOptions> changes = this.compare(this.currentConnection, this.currentHostSpec, connection, hostSpec);
        if (!changes.isEmpty()) {
            boolean shouldCloseConnection;
            Connection oldConnection = this.currentConnection;
            this.currentConnection = connection;
            this.currentHostSpec = hostSpec;
            this.setInTransaction(false);
            EnumSet<OldConnectionSuggestedAction> pluginOpinions = this.pluginManager.notifyConnectionChanged(changes, skipNotificationForThisPlugin);
            boolean bl = shouldCloseConnection = changes.contains((Object)NodeChangeOptions.CONNECTION_OBJECT_CHANGED) && !oldConnection.isClosed() && !pluginOpinions.contains((Object)OldConnectionSuggestedAction.PRESERVE);
            if (shouldCloseConnection) {
                try {
                    oldConnection.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
        return changes;
    }

    protected EnumSet<NodeChangeOptions> compare(@NonNull Connection connA, @NonNull HostSpec hostSpecA, @NonNull Connection connB, @NonNull HostSpec hostSpecB) {
        EnumSet<NodeChangeOptions> changes = EnumSet.noneOf(NodeChangeOptions.class);
        if (connA != connB) {
            changes.add(NodeChangeOptions.CONNECTION_OBJECT_CHANGED);
        }
        changes.addAll(this.compare(hostSpecA, hostSpecB));
        return changes;
    }

    protected EnumSet<NodeChangeOptions> compare(@NonNull HostSpec hostSpecA, @NonNull HostSpec hostSpecB) {
        EnumSet<NodeChangeOptions> changes = EnumSet.noneOf(NodeChangeOptions.class);
        if (!hostSpecA.getHost().equals(hostSpecB.getHost()) || hostSpecA.getPort() != hostSpecB.getPort()) {
            changes.add(NodeChangeOptions.HOSTNAME);
        }
        if (hostSpecA.getRole() != hostSpecB.getRole()) {
            if (hostSpecB.getRole() == HostRole.WRITER) {
                changes.add(NodeChangeOptions.PROMOTED_TO_WRITER);
            } else if (hostSpecB.getRole() == HostRole.READER) {
                changes.add(NodeChangeOptions.PROMOTED_TO_READER);
            }
        }
        if (hostSpecA.getAvailability() != hostSpecB.getAvailability()) {
            if (hostSpecB.getAvailability() == HostAvailability.AVAILABLE) {
                changes.add(NodeChangeOptions.WENT_UP);
            } else if (hostSpecB.getAvailability() == HostAvailability.NOT_AVAILABLE) {
                changes.add(NodeChangeOptions.WENT_DOWN);
            }
        }
        if (!changes.isEmpty()) {
            changes.add(NodeChangeOptions.NODE_CHANGED);
        }
        return changes;
    }

    @Override
    public List<HostSpec> getHosts() {
        return this.hosts;
    }

    @Override
    public void setAvailability(@NonNull Set<String> hostAliases, @NonNull HostAvailability availability) {
        if (hostAliases.isEmpty()) {
            return;
        }
        List hostsToChange = this.getHosts().stream().filter(host -> {
            if (hostAliases.contains(host.asAlias())) return true;
            if (!host.getAliases().stream().anyMatch(hostAliases::contains)) return false;
            return true;
        }).distinct().collect(Collectors.toList());
        if (hostsToChange.isEmpty()) {
            LOGGER.finest(() -> Messages.get("PluginServiceImpl.hostsChangelistEmpty"));
            return;
        }
        HashMap<String, EnumSet<NodeChangeOptions>> changes = new HashMap<String, EnumSet<NodeChangeOptions>>();
        for (HostSpec host2 : hostsToChange) {
            HostAvailability currentAvailability = host2.getAvailability();
            host2.setAvailability(availability);
            hostAvailabilityExpiringCache.put(host2.getUrl(), availability, DEFAULT_HOST_AVAILABILITY_CACHE_EXPIRE_NANO);
            if (currentAvailability == availability) continue;
            EnumSet<NodeChangeOptions> hostChanges = availability == HostAvailability.AVAILABLE ? EnumSet.of(NodeChangeOptions.WENT_UP, NodeChangeOptions.NODE_CHANGED) : EnumSet.of(NodeChangeOptions.WENT_DOWN, NodeChangeOptions.NODE_CHANGED);
            changes.put(host2.getUrl(), hostChanges);
        }
        if (!changes.isEmpty()) {
            this.pluginManager.notifyNodeListChanged(changes);
        }
    }

    @Override
    public boolean isExplicitReadOnly() {
        return this.explicitReadOnly;
    }

    @Override
    public boolean isReadOnly() {
        return this.isExplicitReadOnly() || this.currentHostSpec != null && this.currentHostSpec.getRole() != HostRole.WRITER;
    }

    @Override
    public boolean isInTransaction() {
        return this.isInTransaction;
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.explicitReadOnly = readOnly;
    }

    @Override
    public void setInTransaction(boolean inTransaction) {
        this.isInTransaction = inTransaction;
    }

    @Override
    public HostListProvider getHostListProvider() {
        return this.hostListProvider;
    }

    @Override
    public void refreshHostList() throws SQLException {
        List<HostSpec> updatedHostList = this.getHostListProvider().refresh();
        if (updatedHostList != null) {
            this.updateHostAvailability(updatedHostList);
            this.setNodeList(this.hosts, updatedHostList);
        }
    }

    @Override
    public void refreshHostList(Connection connection) throws SQLException {
        List<HostSpec> updatedHostList = this.getHostListProvider().refresh(connection);
        if (updatedHostList != null) {
            this.updateHostAvailability(updatedHostList);
            this.setNodeList(this.hosts, updatedHostList);
        }
    }

    @Override
    public void forceRefreshHostList() throws SQLException {
        List<HostSpec> updatedHostList = this.getHostListProvider().forceRefresh();
        if (updatedHostList != null) {
            this.updateHostAvailability(updatedHostList);
            this.setNodeList(this.hosts, updatedHostList);
        }
    }

    @Override
    public void forceRefreshHostList(Connection connection) throws SQLException {
        List<HostSpec> updatedHostList = this.getHostListProvider().forceRefresh(connection);
        if (updatedHostList != null) {
            this.updateHostAvailability(updatedHostList);
            this.setNodeList(this.hosts, updatedHostList);
        }
    }

    void setNodeList(@Nullable List<HostSpec> oldHosts, @Nullable List<HostSpec> newHosts) {
        HashMap oldHostMap = oldHosts == null ? new HashMap() : oldHosts.stream().collect(Collectors.toMap(HostSpec::getUrl, value -> value));
        HashMap newHostMap = newHosts == null ? new HashMap() : newHosts.stream().collect(Collectors.toMap(HostSpec::getUrl, value -> value));
        HashMap<String, EnumSet<NodeChangeOptions>> changes = new HashMap<String, EnumSet<NodeChangeOptions>>();
        for (Map.Entry entry : oldHostMap.entrySet()) {
            HostSpec correspondingNewHost = (HostSpec)newHostMap.get(entry.getKey());
            if (correspondingNewHost == null) {
                changes.put((String)entry.getKey(), EnumSet.of(NodeChangeOptions.NODE_DELETED));
                continue;
            }
            EnumSet<NodeChangeOptions> hostChanges = this.compare((HostSpec)entry.getValue(), correspondingNewHost);
            if (hostChanges.isEmpty()) continue;
            changes.put((String)entry.getKey(), hostChanges);
        }
        for (Map.Entry entry : newHostMap.entrySet()) {
            if (oldHostMap.containsKey(entry.getKey())) continue;
            changes.put((String)entry.getKey(), EnumSet.of(NodeChangeOptions.NODE_ADDED));
        }
        if (!changes.isEmpty()) {
            this.hosts = newHosts != null ? newHosts : new ArrayList();
            this.pluginManager.notifyNodeListChanged(changes);
        }
    }

    @Override
    public boolean isStaticHostListProvider() {
        return this.getHostListProvider() instanceof StaticHostListProvider;
    }

    @Override
    public void setHostListProvider(HostListProvider hostListProvider) {
        this.hostListProvider = hostListProvider;
    }

    @Override
    public Connection connect(HostSpec hostSpec, Properties props) throws SQLException {
        return this.pluginManager.connect(this.driverProtocol, hostSpec, props, this.currentConnection == null);
    }

    @Override
    public Connection forceConnect(HostSpec hostSpec, Properties props) throws SQLException {
        return this.pluginManager.forceConnect(this.driverProtocol, hostSpec, props, this.currentConnection == null);
    }

    private void updateHostAvailability(List<HostSpec> hosts) {
        for (HostSpec host : hosts) {
            HostAvailability availability = hostAvailabilityExpiringCache.get(host.getUrl());
            if (availability == null) continue;
            host.setAvailability(availability);
        }
    }

    @Override
    public void releaseResources() {
        LOGGER.fine(() -> Messages.get("PluginServiceImpl.releaseResources"));
        try {
            if (this.currentConnection != null && !this.currentConnection.isClosed()) {
                this.currentConnection.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (this.hostListProvider != null && this.hostListProvider instanceof CanReleaseResources) {
            CanReleaseResources canReleaseResourcesObject = (CanReleaseResources)((Object)this.hostListProvider);
            canReleaseResourcesObject.releaseResources();
        }
    }

    @Override
    public boolean isNetworkException(Throwable throwable) {
        return this.exceptionManager.isNetworkException(this.dialect, throwable);
    }

    @Override
    public boolean isNetworkException(String sqlState) {
        return this.exceptionManager.isNetworkException(this.dialect, sqlState);
    }

    @Override
    public boolean isLoginException(Throwable throwable) {
        return this.exceptionManager.isLoginException(this.dialect, throwable);
    }

    @Override
    public boolean isLoginException(String sqlState) {
        return this.exceptionManager.isLoginException(this.dialect, sqlState);
    }

    @Override
    public Dialect getDialect() {
        return this.dialect;
    }

    @Override
    public void updateDialect(@NonNull Connection connection) throws SQLException {
        this.dialect = this.dialectProvider.getDialect(this.originalUrl, this.initialConnectionHostSpec, connection);
    }
}

