/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.authentication;

import java.util.Properties;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.authentication.AwsCredentialsProviderHandler;
import software.amazon.jdbc.util.Messages;

public class AwsCredentialsManager {
    private static AwsCredentialsProviderHandler handler = null;

    public static synchronized void setCustomHandler(AwsCredentialsProviderHandler customHandler) {
        handler = customHandler;
    }

    public static synchronized void resetCustomHandler() {
        handler = null;
    }

    public static synchronized AwsCredentialsProvider getProvider(HostSpec hostSpec, Properties props) {
        AwsCredentialsProvider provider;
        AwsCredentialsProvider awsCredentialsProvider = provider = handler != null ? handler.getAwsCredentialsProvider(hostSpec, props) : AwsCredentialsManager.getDefaultProvider();
        if (provider == null) {
            throw new IllegalArgumentException(Messages.get("AwsCredentialsManager.nullProvider"));
        }
        return provider;
    }

    private static AwsCredentialsProvider getDefaultProvider() {
        return DefaultCredentialsProvider.create();
    }
}

