/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import software.amazon.jdbc.ConnectionProvider;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.PropertyDefinition;
import software.amazon.jdbc.util.ConnectionUrlBuilder;
import software.amazon.jdbc.util.PropertyUtils;
import software.amazon.jdbc.util.StringUtils;

public class DataSourceConnectionProvider
implements ConnectionProvider {
    private final @NonNull DataSource dataSource;
    private final @Nullable String serverPropertyName;
    private final @Nullable String portPropertyName;
    private final @Nullable String urlPropertyName;
    private final @Nullable String databasePropertyName;

    public DataSourceConnectionProvider(@NonNull DataSource dataSource, @Nullable String serverPropertyName, @Nullable String portPropertyName, @Nullable String urlPropertyName, @Nullable String databasePropertyName) {
        this.dataSource = dataSource;
        this.serverPropertyName = serverPropertyName;
        this.portPropertyName = portPropertyName;
        this.urlPropertyName = urlPropertyName;
        this.databasePropertyName = databasePropertyName;
    }

    @Override
    public Connection connect(@NonNull String protocol, @NonNull HostSpec hostSpec, @NonNull Properties props) throws SQLException {
        Properties copy = PropertyUtils.copyProperties(props);
        if (!StringUtils.isNullOrEmpty(this.serverPropertyName)) {
            copy.setProperty(this.serverPropertyName, hostSpec.getHost());
        }
        if (hostSpec.isPortSpecified() && !StringUtils.isNullOrEmpty(this.portPropertyName)) {
            copy.put(this.portPropertyName, (Object)hostSpec.getPort());
        }
        if (!StringUtils.isNullOrEmpty(this.databasePropertyName) && !StringUtils.isNullOrEmpty(PropertyDefinition.DATABASE.getString(props))) {
            copy.setProperty(this.databasePropertyName, PropertyDefinition.DATABASE.getString(props));
        }
        if (!StringUtils.isNullOrEmpty(this.urlPropertyName)) {
            Properties urlProperties = PropertyUtils.copyProperties(copy);
            if (!StringUtils.isNullOrEmpty(props.getProperty(this.urlPropertyName))) {
                urlProperties.remove(this.urlPropertyName);
            }
            copy.setProperty(this.urlPropertyName, ConnectionUrlBuilder.buildUrl(protocol, hostSpec, this.serverPropertyName, this.portPropertyName, this.databasePropertyName, urlProperties));
        }
        PropertyDefinition.removeAllExceptCredentials(copy);
        PropertyUtils.applyProperties(this.dataSource, copy);
        return this.dataSource.getConnection();
    }

    @Override
    public Connection connect(@NonNull String url, @NonNull Properties props) throws SQLException {
        Properties copy = PropertyUtils.copyProperties(props);
        if (!StringUtils.isNullOrEmpty(this.urlPropertyName)) {
            copy.setProperty(this.urlPropertyName, url);
        }
        if (!StringUtils.isNullOrEmpty(this.databasePropertyName) && !StringUtils.isNullOrEmpty(PropertyDefinition.DATABASE.getString(props))) {
            copy.put(this.databasePropertyName, PropertyDefinition.DATABASE.getString(props));
        }
        PropertyDefinition.removeAllExceptCredentials(copy);
        PropertyUtils.applyProperties(this.dataSource, copy);
        return this.dataSource.getConnection();
    }
}

