/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.util;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SqlState {
    public static final SqlState UNKNOWN_STATE = new SqlState("");
    public static final SqlState CONNECTION_FAILURE_DURING_TRANSACTION = new SqlState("08007");
    public static final SqlState COMMUNICATION_LINK_CHANGED = new SqlState("08S02");
    public static final SqlState CONNECTION_UNABLE_TO_CONNECT = new SqlState("08001");
    public static final SqlState CONNECTION_NOT_OPEN = new SqlState("08003");
    private static final List<String> PG_SQLSTATES = Arrays.asList("53", "57P01", "57P02", "57P03", "58", "99", "F0", "XX");
    private final String sqlState;

    SqlState(String sqlState) {
        this.sqlState = sqlState;
    }

    public String getState() {
        return this.sqlState;
    }

    public static boolean isConnectionError(SQLException sqlException) {
        return SqlState.isConnectionError(sqlException.getSQLState());
    }

    public static boolean isConnectionError(@Nullable String sqlState) {
        if (sqlState == null) {
            return false;
        }
        if (sqlState.startsWith("08")) {
            return true;
        }
        for (String pgSqlState : PG_SQLSTATES) {
            if (!sqlState.startsWith(pgSqlState)) continue;
            return true;
        }
        return false;
    }
}

