/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.plugin.efm;

import java.sql.Connection;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.amazon.jdbc.AwsWrapperProperty;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.PluginService;
import software.amazon.jdbc.plugin.efm.ExecutorServiceInitializer;
import software.amazon.jdbc.plugin.efm.Monitor;
import software.amazon.jdbc.plugin.efm.MonitorConnectionContext;
import software.amazon.jdbc.plugin.efm.MonitorImpl;
import software.amazon.jdbc.plugin.efm.MonitorInitializer;
import software.amazon.jdbc.plugin.efm.MonitorService;
import software.amazon.jdbc.plugin.efm.MonitorThreadContainer;
import software.amazon.jdbc.util.Messages;

public class MonitorServiceImpl
implements MonitorService {
    private static final Logger LOGGER = Logger.getLogger(MonitorServiceImpl.class.getName());
    protected static final AwsWrapperProperty MONITOR_DISPOSAL_TIME_MS = new AwsWrapperProperty("monitorDisposalTime", "60000", "Interval in milliseconds for a monitor to be considered inactive and to be disposed.");
    MonitorThreadContainer threadContainer;
    final MonitorInitializer monitorInitializer;

    public MonitorServiceImpl(@NonNull PluginService pluginService) {
        this((hostSpec, properties, monitorService) -> new MonitorImpl(pluginService, hostSpec, properties, MONITOR_DISPOSAL_TIME_MS.getLong(properties), monitorService), () -> Executors.newCachedThreadPool(r -> {
            Thread monitoringThread = new Thread(r);
            monitoringThread.setDaemon(true);
            return monitoringThread;
        }));
    }

    MonitorServiceImpl(MonitorInitializer monitorInitializer, ExecutorServiceInitializer executorServiceInitializer) {
        this.monitorInitializer = monitorInitializer;
        this.threadContainer = MonitorThreadContainer.getInstance(executorServiceInitializer);
    }

    @Override
    public MonitorConnectionContext startMonitoring(Connection connectionToAbort, Set<String> nodeKeys, HostSpec hostSpec, Properties properties, int failureDetectionTimeMillis, int failureDetectionIntervalMillis, int failureDetectionCount) {
        if (nodeKeys.isEmpty()) {
            LOGGER.warning(() -> Messages.get("MonitorServiceImpl.emptyAliasSet", new Object[]{hostSpec}));
            hostSpec.addAlias(hostSpec.asAlias());
        }
        Monitor monitor = this.getMonitor(nodeKeys, hostSpec, properties);
        MonitorConnectionContext context = new MonitorConnectionContext(connectionToAbort, nodeKeys, failureDetectionTimeMillis, failureDetectionIntervalMillis, failureDetectionCount);
        monitor.startMonitoring(context);
        return context;
    }

    @Override
    public void stopMonitoring(@NonNull MonitorConnectionContext context) {
        context.invalidate();
        for (String nodeKey : context.getHostAliases()) {
            Monitor monitor = this.threadContainer.getMonitor(nodeKey);
            if (monitor == null) continue;
            monitor.stopMonitoring(context);
            return;
        }
        LOGGER.finest(() -> Messages.get("MonitorServiceImpl.monitorNotFoundForContext"));
    }

    @Override
    public void stopMonitoringForAllConnections(@NonNull Set<String> nodeKeys) {
        for (String nodeKey : nodeKeys) {
            Monitor monitor = this.threadContainer.getMonitor(nodeKey);
            if (monitor == null) continue;
            monitor.clearContexts();
            this.threadContainer.resetResource(monitor);
            return;
        }
    }

    @Override
    public void releaseResources() {
        this.threadContainer = null;
        MonitorThreadContainer.releaseInstance();
    }

    @Override
    public void notifyUnused(Monitor monitor) {
        if (monitor == null) {
            LOGGER.warning(() -> Messages.get("MonitorServiceImpl.nullMonitorParam"));
            return;
        }
        this.threadContainer.releaseResource(monitor);
    }

    protected Monitor getMonitor(Set<String> nodeKeys, HostSpec hostSpec, Properties properties) {
        return this.threadContainer.getOrCreateMonitor(nodeKeys, () -> this.monitorInitializer.createMonitor(hostSpec, properties, this));
    }
}

