/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.ionpathextraction;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import software.amazon.ion.IonReader;
import software.amazon.ion.IonType;
import software.amazon.ionpathextraction.PathExtractor;
import software.amazon.ionpathextraction.PathExtractorConfig;
import software.amazon.ionpathextraction.SearchPath;
import software.amazon.ionpathextraction.pathcomponents.PathComponent;
import software.amazon.ionpathextraction.utils.Preconditions;

class PathExtractorImpl
implements PathExtractor {
    private final PathExtractorConfig config;
    private final Tracker tracker;
    private final List<SearchPath> searchPaths;

    PathExtractorImpl(List<SearchPath> searchPaths, PathExtractorConfig config) {
        this.searchPaths = searchPaths;
        this.config = config;
        int maxSearchPathDepth = searchPaths.stream().mapToInt(sp -> sp.getPathComponents().size()).max().orElse(0);
        this.tracker = new Tracker(maxSearchPathDepth);
    }

    @Override
    public void match(IonReader reader) {
        Preconditions.checkArgument(reader.getDepth() == 0 || this.config.isMatchRelativePaths(), "reader must be at depth zero, it was at:" + reader.getDepth());
        if (this.searchPaths.isEmpty()) {
            return;
        }
        this.tracker.reset(this.searchPaths);
        this.tracker.setInitialReaderDepth(reader.getDepth());
        this.matchRecursive(reader);
    }

    private int matchRecursive(IonReader reader) {
        int currentDepth = this.tracker.getCurrentDepth();
        int ordinal = 0;
        while (reader.next() != null) {
            ArrayList<SearchPath> partialMatches = new ArrayList<SearchPath>();
            for (SearchPath sp : this.tracker.activePaths()) {
                int stepOutTimes;
                boolean match = this.pathComponentMatches(sp, reader, ordinal);
                boolean isTerminal = this.isTerminal(sp);
                if (match && isTerminal && (stepOutTimes = this.invokeCallback(reader, sp)) > 0) {
                    return stepOutTimes - 1;
                }
                if (isTerminal || currentDepth != 0 && !match) continue;
                partialMatches.add(sp);
            }
            if (IonType.isContainer((IonType)reader.getType()) && !partialMatches.isEmpty()) {
                this.tracker.push(partialMatches);
                reader.stepIn();
                int stepOutTimes = this.matchRecursive(reader);
                reader.stepOut();
                this.tracker.pop();
                if (stepOutTimes > 0) {
                    return stepOutTimes - 1;
                }
            }
            ++ordinal;
        }
        return 0;
    }

    private int invokeCallback(IonReader reader, SearchPath searchPath) {
        int previousReaderDepth = reader.getDepth();
        int stepOutTimes = searchPath.getCallback().apply(reader);
        int newReaderDepth = reader.getDepth();
        Preconditions.checkState(previousReaderDepth == newReaderDepth, "Reader must be at same depth when returning from callbacks. initial: " + previousReaderDepth + ", new: " + newReaderDepth);
        int readerRelativeDepth = reader.getDepth() - this.tracker.getInitialReaderDepth();
        Preconditions.checkState(stepOutTimes <= readerRelativeDepth, "Callback return cannot be greater than the reader current relative depth. return: " + stepOutTimes + ", relative reader depth: " + readerRelativeDepth);
        return stepOutTimes;
    }

    private boolean pathComponentMatches(SearchPath searchPath, IonReader reader, int currentPosition) {
        int depth = this.tracker.getCurrentDepth();
        List<PathComponent> pathComponents = searchPath.getPathComponents();
        if (depth == 0) {
            return pathComponents.isEmpty();
        }
        if (depth <= pathComponents.size()) {
            return pathComponents.get(depth - 1).matches(reader, currentPosition, this.config);
        }
        return false;
    }

    private boolean isTerminal(SearchPath searchPath) {
        return this.tracker.getCurrentDepth() == searchPath.getPathComponents().size();
    }

    private static class Tracker {
        private final Deque<List<SearchPath>> stack;
        private int initialReaderDepth;

        Tracker(int size) {
            this.stack = new ArrayDeque<List<SearchPath>>(size);
        }

        void reset(List<SearchPath> searchPaths) {
            this.stack.clear();
            this.stack.push(searchPaths);
        }

        List<SearchPath> activePaths() {
            return this.stack.peek();
        }

        int getCurrentDepth() {
            return this.stack.size() - 1;
        }

        void push(List<SearchPath> partialMatches) {
            this.stack.push(partialMatches);
        }

        void pop() {
            this.stack.pop();
        }

        int getInitialReaderDepth() {
            return this.initialReaderDepth;
        }

        void setInitialReaderDepth(int depth) {
            this.initialReaderDepth = depth;
        }
    }
}

