/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.encryption.s3.internal;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collections;
import java.util.Map;
import software.amazon.encryption.s3.algorithms.AlgorithmSuite;
import software.amazon.encryption.s3.materials.EncryptedDataKey;

public class ContentMetadata {
    private final AlgorithmSuite _algorithmSuite;
    private final EncryptedDataKey _encryptedDataKey;
    private final String _encryptedDataKeyAlgorithm;
    private final Map<String, String> _encryptionContextOrMatDesc;
    private final byte[] _contentIv;
    private final String _contentCipher;
    private final String _contentCipherTagLength;
    private final String _contentRange;

    private ContentMetadata(Builder builder) {
        this._algorithmSuite = builder._algorithmSuite;
        this._encryptedDataKey = builder._encryptedDataKey;
        this._encryptedDataKeyAlgorithm = builder._encryptedDataKeyAlgorithm;
        this._encryptionContextOrMatDesc = builder._encryptionContextOrMatDesc;
        this._contentIv = builder._contentIv;
        this._contentCipher = builder._contentCipher;
        this._contentCipherTagLength = builder._contentCipherTagLength;
        this._contentRange = builder._contentRange;
    }

    public static Builder builder() {
        return new Builder();
    }

    public AlgorithmSuite algorithmSuite() {
        return this._algorithmSuite;
    }

    public EncryptedDataKey encryptedDataKey() {
        return this._encryptedDataKey;
    }

    public String encryptedDataKeyAlgorithm() {
        return this._encryptedDataKeyAlgorithm;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="False positive; underlying implementation is immutable")
    public Map<String, String> encryptedDataKeyMatDescOrContext() {
        return this._encryptionContextOrMatDesc;
    }

    public byte[] contentIv() {
        if (this._contentIv == null) {
            return null;
        }
        return (byte[])this._contentIv.clone();
    }

    public String contentCipher() {
        return this._contentCipher;
    }

    public String contentCipherTagLength() {
        return this._contentCipherTagLength;
    }

    public String contentRange() {
        return this._contentRange;
    }

    public static class Builder {
        private AlgorithmSuite _algorithmSuite;
        private EncryptedDataKey _encryptedDataKey;
        private String _encryptedDataKeyAlgorithm;
        private Map<String, String> _encryptionContextOrMatDesc;
        private byte[] _contentIv;
        private String _contentCipher;
        private String _contentCipherTagLength;
        public String _contentRange;

        private Builder() {
        }

        public Builder algorithmSuite(AlgorithmSuite algorithmSuite) {
            this._algorithmSuite = algorithmSuite;
            return this;
        }

        public Builder encryptedDataKey(EncryptedDataKey encryptedDataKey) {
            this._encryptedDataKey = encryptedDataKey;
            return this;
        }

        public Builder encryptedDataKeyAlgorithm(String encryptedDataKeyAlgorithm) {
            this._encryptedDataKeyAlgorithm = encryptedDataKeyAlgorithm;
            return this;
        }

        public Builder encryptionContextOrMatDesc(Map<String, String> encryptionContextOrMatDesc) {
            this._encryptionContextOrMatDesc = Collections.unmodifiableMap(encryptionContextOrMatDesc);
            return this;
        }

        public Builder contentIv(byte[] contentIv) {
            this._contentIv = (byte[])contentIv.clone();
            return this;
        }

        public Builder contentRange(String contentRange) {
            this._contentRange = contentRange;
            return this;
        }

        public ContentMetadata build() {
            return new ContentMetadata(this);
        }
    }
}

