/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dynamodb.services.local.shared.access.api.ttl;

import org.apache.commons.lang3.StringUtils;
import software.amazon.awssdk.services.dynamodb.model.TimeToLiveSpecification;
import software.amazon.awssdk.services.dynamodb.model.UpdateTimeToLiveRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateTimeToLiveResponse;
import software.amazon.dynamodb.services.exceptions.AWSExceptionFactory;
import software.amazon.dynamodb.services.exceptions.AmazonServiceExceptionType;
import software.amazon.dynamodb.services.local.shared.access.LocalDBAccess;
import software.amazon.dynamodb.services.local.shared.access.TableInfo;
import software.amazon.dynamodb.services.local.shared.access.api.DynamoDbApiFunction;
import software.amazon.dynamodb.services.local.shared.exceptions.LocalDBClientExceptionMessage;

public class UpdateTimeToLiveFunction
extends DynamoDbApiFunction<UpdateTimeToLiveRequest, UpdateTimeToLiveResponse> {
    public UpdateTimeToLiveFunction(LocalDBAccess dbAccess) {
        super(dbAccess);
    }

    @Override
    public UpdateTimeToLiveResponse apply(UpdateTimeToLiveRequest updateTimeToLiveRequest) {
        String unparsedTableName = updateTimeToLiveRequest.tableName();
        final String tableName = this.getTableNameFromPossibleArn(unparsedTableName);
        updateTimeToLiveRequest = (UpdateTimeToLiveRequest)updateTimeToLiveRequest.toBuilder().tableName(tableName).build();
        this.validateTableName(tableName);
        TableInfo tableInfo = this.validateTableExists(tableName);
        final TimeToLiveSpecification timeToLiveSpecification = updateTimeToLiveRequest.timeToLiveSpecification();
        if (timeToLiveSpecification == null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.NULL_TIME_TO_LIVE_SPECIFICATION.getMessage());
        }
        if (timeToLiveSpecification.enabled() == null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.NULL_ENABLE_FLAG_IN_TIME_TO_LIVE_SPECIFICATION.getMessage());
        }
        final String timeToLiveAttributeName = timeToLiveSpecification.attributeName();
        if (timeToLiveAttributeName == null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.NULL_TIME_TO_LIVE_ATTRIBUTE_NAME.getMessage());
        }
        if (timeToLiveSpecification.enabled().booleanValue()) {
            this.validateAttributeName(timeToLiveAttributeName);
            if (tableInfo.getTimeToLiveSpecification() != null) {
                if (tableInfo.getTimeToLiveSpecification().attributeName() != null && !StringUtils.equals((CharSequence)tableInfo.getTimeToLiveSpecification().attributeName(), (CharSequence)timeToLiveAttributeName)) {
                    throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.TIME_TO_LIVE_CONFLICTING_ATTRIBUTE_NAME.getMessage());
                }
                if (tableInfo.getTimeToLiveSpecification().enabled().booleanValue()) {
                    throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.TIME_TO_LIVE_ALREADY_ENABLED.getMessage());
                }
            }
        } else {
            if (tableInfo.getTimeToLiveSpecification() == null || !tableInfo.getTimeToLiveSpecification().enabled().booleanValue()) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.TIME_TO_LIVE_ALREADY_DISABLED.getMessage());
            }
            if (tableInfo.getTimeToLiveSpecification().attributeName() != null && !StringUtils.equals((CharSequence)tableInfo.getTimeToLiveSpecification().attributeName(), (CharSequence)timeToLiveAttributeName)) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.TIME_TO_LIVE_CONFLICTING_ATTRIBUTE_NAME.getMessage());
            }
        }
        new LocalDBAccess.WriteLockWithTimeout(this.dbAccess.getLockForTable(tableName), 10){

            @Override
            public void criticalSection() {
                if (!timeToLiveSpecification.enabled().booleanValue()) {
                    UpdateTimeToLiveFunction.this.dbAccess.updateTable(tableName, null);
                } else {
                    UpdateTimeToLiveFunction.this.dbAccess.updateTable(tableName, timeToLiveAttributeName);
                }
            }
        }.execute();
        return (UpdateTimeToLiveResponse)UpdateTimeToLiveResponse.builder().timeToLiveSpecification(updateTimeToLiveRequest.timeToLiveSpecification()).build();
    }
}

