/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dynamodb.services.local.shared.access.sqlite;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinition;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaElement;
import software.amazon.awssdk.services.dynamodb.model.KeyType;
import software.amazon.dynamodb.services.local.shared.access.LocalDBUtils;
import software.amazon.dynamodb.services.local.shared.access.sqlite.DataTypes;
import software.amazon.dynamodb.services.local.shared.exceptions.LocalDBAccessExceptionType;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SQLiteIndexElement {
    private AttributeDefinition dynamoDBAttribute = null;
    private KeyType keyType = null;
    private String sqliteColumnName = null;
    private DataTypes sqliteDataType = null;

    public SQLiteIndexElement() {
    }

    public SQLiteIndexElement(KeySchemaElement keySchemaElement, List<AttributeDefinition> attributes, String sqliteColumnName) {
        this(keySchemaElement.attributeName(), keySchemaElement.keyTypeAsString(), attributes, sqliteColumnName);
    }

    private SQLiteIndexElement(String keyAttributeName, String keyType, List<AttributeDefinition> attributes, String sqliteColumnName) {
        AttributeDefinition retrievedAttributeDefinition = null;
        for (AttributeDefinition attributeDefinition : attributes) {
            if (!attributeDefinition.attributeName().equals(keyAttributeName)) continue;
            retrievedAttributeDefinition = attributeDefinition;
            break;
        }
        LocalDBUtils.ldAccessAssertTrue(retrievedAttributeDefinition == null, LocalDBAccessExceptionType.VALIDATION_EXCEPTION, "Given attribute name (%s) not found in list of attribute definitions.", keyAttributeName);
        this.initialize(KeyType.fromValue((String)keyType), retrievedAttributeDefinition, sqliteColumnName);
    }

    public SQLiteIndexElement(KeyType keyAttributeType, AttributeDefinition attributeDefinition, String sqliteColumnName) {
        this.initialize(keyAttributeType, attributeDefinition, sqliteColumnName);
    }

    public static DataTypes getSQLiteDataType(AttributeDefinition attributeDefinition) {
        if (attributeDefinition.attributeTypeAsString().equals("S")) {
            return DataTypes.TEXT;
        }
        if (attributeDefinition.attributeTypeAsString().equals("B")) {
            return DataTypes.BLOB;
        }
        if (attributeDefinition.attributeTypeAsString().equals("N")) {
            return DataTypes.BLOB;
        }
        throw new IllegalArgumentException("Unknown Attribute Type: " + attributeDefinition.attributeTypeAsString());
    }

    @JsonProperty(value="DynamoDBAttribute")
    public AttributeDefinition getDynamoDBAttribute() {
        return this.dynamoDBAttribute;
    }

    @JsonProperty(value="DynamoDBAttribute")
    public void setDynamoDBAttribute(AttributeDefinition dynamoDBAttribute) {
        this.dynamoDBAttribute = dynamoDBAttribute;
    }

    @JsonProperty(value="KeyType")
    public KeyType getKeyType() {
        return this.keyType;
    }

    @JsonProperty(value="KeyType")
    public void setKeyType(KeyType keyType) {
        this.keyType = keyType;
    }

    @JsonProperty(value="SQLiteColumnName")
    public String getSqliteColumnName() {
        return this.sqliteColumnName;
    }

    @JsonProperty(value="SQLiteColumnName")
    public void setSqliteColumnName(String sqliteColumnName) {
        this.sqliteColumnName = sqliteColumnName;
    }

    @JsonProperty(value="SQLiteDataType")
    public DataTypes getSqliteDataType() {
        return this.sqliteDataType;
    }

    @JsonProperty(value="SQLiteDataType")
    public void setSqliteDataType(DataTypes sqliteDataType) {
        this.sqliteDataType = sqliteDataType;
    }

    private void initialize(KeyType keyAttributeType, AttributeDefinition attributeDefinition, String sqliteColumnName) {
        this.dynamoDBAttribute = attributeDefinition;
        this.keyType = keyAttributeType;
        this.sqliteColumnName = sqliteColumnName;
        this.sqliteDataType = SQLiteIndexElement.getSQLiteDataType(this.dynamoDBAttribute);
    }

    public String toString() {
        return "{" + this.dynamoDBAttribute.attributeName() + ":" + this.dynamoDBAttribute.attributeTypeAsString() + "}\t" + this.keyType.toString() + "\t" + this.sqliteColumnName + "\t" + this.sqliteDataType.toString();
    }
}

