/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dynamodb.services.local.shared.access.sqlite;

import com.almworks.sqlite4java.SQLiteException;
import com.almworks.sqlite4java.SQLiteStatement;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndex;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaElement;
import software.amazon.awssdk.services.dynamodb.model.KeyType;
import software.amazon.awssdk.services.dynamodb.model.LocalSecondaryIndex;
import software.amazon.awssdk.services.dynamodb.model.StreamRecord;
import software.amazon.awssdk.services.dynamodb.model.StreamViewType;
import software.amazon.dynamodb.services.local.shared.access.LocalDBUtils;
import software.amazon.dynamodb.services.local.shared.access.PaddingNumberEncoder;
import software.amazon.dynamodb.services.local.shared.access.sqlite.SQLiteDBAccess;
import software.amazon.dynamodb.services.local.shared.access.sqlite.SQLiteIndexElement;
import software.amazon.dynamodb.services.local.shared.access.sqlite.TableSchemaInfo;
import software.amazon.dynamodb.services.local.shared.exceptions.LocalDBAccessExceptionType;
import software.amazon.dynamodb.services.local.shared.model.AttributeValue;

public class SQLiteDBAccessUtils {
    static StreamRecord constructInternalStreamRecord(Map<String, AttributeValue> key, Map<String, AttributeValue> oldRecord, Map<String, AttributeValue> newRecord, StreamViewType streamViewType) {
        StreamRecord.Builder ret = StreamRecord.builder().keys(SQLiteDBAccessUtils.convertLocalAttributeValues(key)).streamViewType(streamViewType);
        switch (streamViewType) {
            case KEYS_ONLY: {
                ret.sizeBytes(Long.valueOf(LocalDBUtils.getItemSizeBytes(key)));
                break;
            }
            case NEW_AND_OLD_IMAGES: {
                ret.newImage(SQLiteDBAccessUtils.convertLocalAttributeValues(newRecord)).oldImage(SQLiteDBAccessUtils.convertLocalAttributeValues(oldRecord)).sizeBytes(Long.valueOf(LocalDBUtils.getItemSizeBytes(key) + LocalDBUtils.getItemSizeBytes(newRecord) + LocalDBUtils.getItemSizeBytes(oldRecord)));
                break;
            }
            case NEW_IMAGE: {
                ret.newImage(SQLiteDBAccessUtils.convertLocalAttributeValues(newRecord)).sizeBytes(Long.valueOf(LocalDBUtils.getItemSizeBytes(key) + LocalDBUtils.getItemSizeBytes(newRecord)));
                break;
            }
            case OLD_IMAGE: {
                ret.oldImage(SQLiteDBAccessUtils.convertLocalAttributeValues(oldRecord)).sizeBytes(Long.valueOf(LocalDBUtils.getItemSizeBytes(key) + LocalDBUtils.getItemSizeBytes(oldRecord)));
                break;
            }
        }
        return (StreamRecord)ret.build();
    }

    private static Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue> convertLocalAttributeValues(Map<String, AttributeValue> valueMap) {
        if (valueMap == null || valueMap.isEmpty()) {
            return null;
        }
        HashMap<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue> ret = new HashMap<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue>();
        for (Map.Entry<String, AttributeValue> entry : valueMap.entrySet()) {
            AttributeValue attributeValue = entry.getValue();
            ret.put(entry.getKey(), SQLiteDBAccessUtils.convertLocalAttributeValue(attributeValue));
        }
        return ret;
    }

    public static software.amazon.awssdk.services.dynamodb.model.AttributeValue convertLocalAttributeValue(AttributeValue attributeValue) {
        AttributeValue.Builder converted = software.amazon.awssdk.services.dynamodb.model.AttributeValue.builder().b(attributeValue.getB() == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)attributeValue.getB())).bs(attributeValue.getBsAsSDKBytes()).n(attributeValue.getN()).ns(attributeValue.getNS()).s(attributeValue.getS()).ss(attributeValue.getSS()).bool(attributeValue.getBOOL()).nul(attributeValue.isNULL()).m(SQLiteDBAccessUtils.convertLocalAttributeValues(attributeValue.getM()));
        if (attributeValue.getL() != null) {
            ArrayList<software.amazon.awssdk.services.dynamodb.model.AttributeValue> list = new ArrayList<software.amazon.awssdk.services.dynamodb.model.AttributeValue>();
            for (AttributeValue val : attributeValue.getL()) {
                list.add(SQLiteDBAccessUtils.convertLocalAttributeValue(val));
            }
            converted.l(list);
        }
        return (software.amazon.awssdk.services.dynamodb.model.AttributeValue)converted.build();
    }

    static Map<String, AttributeValue> constructKey(TableSchemaInfo tableSchemaInfo, AttributeValue hashKey, AttributeValue rangeKey) {
        HashMap<String, AttributeValue> key = new HashMap<String, AttributeValue>();
        key.put(tableSchemaInfo.getHashKeyDefinition().attributeName(), hashKey);
        if (rangeKey != null) {
            key.put(tableSchemaInfo.getRangeKeyDefinition().attributeName(), rangeKey);
        }
        return key;
    }

    static String constructIndexWhereClause(List<SQLiteIndexElement> indexes) {
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < indexes.size(); ++i) {
            ret.append(indexes.get(i).getSqliteColumnName()).append(" = ?");
            if (i >= indexes.size() - 1) continue;
            ret.append(" AND ");
        }
        return ret.toString();
    }

    static void applyKeyBinds(SQLiteStatement statement, List<SQLiteIndexElement> indexElements, Map<String, AttributeValue> key) throws SQLiteException {
        for (int i = 0; i < indexElements.size(); ++i) {
            String attributeName = indexElements.get(i).getDynamoDBAttribute().attributeName();
            byte[] value = SQLiteDBAccessUtils.translateKeyAttributeValue(key.get(attributeName));
            statement.bind(i + 1, value);
        }
    }

    static String escapedTableName(String s) {
        return "\"" + s + "\"";
    }

    static byte[] translateKeyAttributeValue(AttributeValue attributeValue) {
        if (attributeValue.getB() != null) {
            return SQLiteDBAccessUtils.byteBufferToArray(attributeValue.getB());
        }
        if (attributeValue.getN() != null) {
            return PaddingNumberEncoder.encodeBigDecimal(new BigDecimal(attributeValue.getN()));
        }
        if (attributeValue.getS() != null) {
            return attributeValue.getS().getBytes(LocalDBUtils.UTF8);
        }
        throw new IllegalArgumentException("Unknown AttributeValue type: " + attributeValue);
    }

    static String getLSIIndexKeyDynamoDBName(TableSchemaInfo tableSchema, String indexName) {
        List<LocalSecondaryIndex> lsiList = tableSchema.getLsiList();
        for (LocalSecondaryIndex lsi : lsiList) {
            if (!lsi.indexName().equals(indexName)) continue;
            List keySchema = lsi.keySchema();
            for (KeySchemaElement kse : keySchema) {
                if (!kse.keyType().equals((Object)KeyType.RANGE)) continue;
                return kse.attributeName();
            }
        }
        return null;
    }

    static String getGSIKeyDynamoDBName(TableSchemaInfo tableSchema, String indexName, String keyType) {
        List<GlobalSecondaryIndex> gsiList = tableSchema.getGsiList();
        for (GlobalSecondaryIndex gsi : gsiList) {
            if (!gsi.indexName().equals(indexName)) continue;
            List keySchema = gsi.keySchema();
            for (KeySchemaElement kse : keySchema) {
                if (!kse.keyTypeAsString().equals(keyType)) continue;
                return kse.attributeName();
            }
        }
        return null;
    }

    public static int applyBinds(SQLiteStatement statement, int startBind, List<byte[]> bindData) throws SQLiteException {
        ArrayList<SQLiteDBAccess.BindValue> bindValues = new ArrayList<SQLiteDBAccess.BindValue>();
        for (byte[] data : bindData) {
            bindValues.add(new SQLiteDBAccess.BindValue().withBytes(data));
        }
        return SQLiteDBAccessUtils.applyBindsWithBindValues(statement, startBind, bindValues);
    }

    public static int applyBindsWithBindValues(SQLiteStatement statement, int startBind, List<SQLiteDBAccess.BindValue> bindValues) throws SQLiteException {
        int endBind = startBind;
        LocalDBUtils.ldAccessAssertTrue(startBind > 0, LocalDBAccessExceptionType.UNEXPECTED_EXCEPTION, "SQL construction issue, binding at location 0.", new Object[0]);
        LocalDBUtils.ldAccessAssertTrue(endBind + bindValues.size() - 1 <= statement.getBindParameterCount(), LocalDBAccessExceptionType.UNEXPECTED_EXCEPTION, "SQL construction issue, invalid number of binds.", new Object[0]);
        int j = 0;
        while (j < bindValues.size()) {
            if (bindValues.get(j).getText() != null) {
                statement.bind(endBind, bindValues.get(j).getText());
            } else {
                statement.bind(endBind, bindValues.get(j).getBytes());
            }
            ++j;
            ++endBind;
        }
        return endBind;
    }

    public static byte[] byteBufferToArray(ByteBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        if (buffer.hasArray() && !buffer.isReadOnly()) {
            return buffer.array();
        }
        ByteBuffer duplicate = buffer.duplicate();
        byte[] bytes = new byte[duplicate.remaining()];
        duplicate.get(bytes);
        return bytes;
    }
}

