/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.agent.inject;

import java.io.File;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import software.amazon.disco.agent.jar.bytebuddy.agent.ByteBuddyAgent;

public class Injector {
    public static Instrumentation createInstrumentation() {
        return ByteBuddyAgent.install();
    }

    public static void loadAgent(String agentJarPath, String agentArgs) {
        try {
            Injector.loadAgent(Injector.createInstrumentation(), agentJarPath, agentArgs);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadAgent(Instrumentation instrumentation, String agentJarPath, String agentArgs) {
        ZipFile jar = null;
        try {
            File jarFile = new File(agentJarPath);
            jar = Injector.addToBootstrapClasspath(instrumentation, jarFile);
            String premainClass = ((JarFile)jar).getManifest().getMainAttributes().getValue("Premain-Class");
            Class.forName(premainClass, true, null).getDeclaredMethod("premain", String.class, Instrumentation.class).invoke(null, agentArgs, instrumentation);
        }
        catch (Throwable throwable) {
        }
        finally {
            if (jar != null) {
                try {
                    jar.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public static JarFile addToSystemClasspath(Instrumentation instrumentation, File jarFile) {
        try {
            JarFile jar = new JarFile(jarFile);
            instrumentation.appendToSystemClassLoaderSearch(jar);
            return jar;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static JarFile addToBootstrapClasspath(Instrumentation instrumentation, File jarFile) {
        try {
            JarFile jar = new JarFile(jarFile);
            instrumentation.appendToBootstrapClassLoaderSearch(jar);
            Class<?> classFileLocator = Class.forName("software.amazon.disco.agent.jar.bytebuddy.dynamic.ClassFileLocator$ForClassLoader");
            Field bootLoaderProxyField = classFileLocator.getDeclaredField("BOOT_LOADER_PROXY");
            bootLoaderProxyField.setAccessible(true);
            Object bootLoaderProxy = bootLoaderProxyField.get(null);
            Injector.addURL(bootLoaderProxy, jarFile.toURI().toURL());
            return jar;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    static void addURL(Object classLoader, URL url) throws Exception {
        Method addURL = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
        addURL.setAccessible(true);
        addURL.invoke(classLoader, url);
    }
}

