/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.agent.concurrent;

import java.util.concurrent.ConcurrentMap;
import software.amazon.disco.agent.concurrent.MetadataItem;
import software.amazon.disco.agent.concurrent.TransactionContext;
import software.amazon.disco.agent.event.EventBus;
import software.amazon.disco.agent.event.ThreadEnterEvent;
import software.amazon.disco.agent.event.ThreadExitEvent;
import software.amazon.disco.agent.logging.LogManager;
import software.amazon.disco.agent.logging.Logger;

public class ConcurrentUtils {
    private static Logger log = LogManager.getLogger(ConcurrentUtils.class);

    public static void set(long ancestralThreadId, long parentThreadId, ConcurrentMap<String, MetadataItem> discoTransactionContext) {
        if (discoTransactionContext == null) {
            log.error("DiSCo(Core) could not propagate null context from thread id " + ancestralThreadId + " to thread id " + Thread.currentThread().getId());
            return;
        }
        long thisThreadId = Thread.currentThread().getId();
        if (ancestralThreadId != thisThreadId && !ConcurrentUtils.isDiscoNullId(discoTransactionContext)) {
            TransactionContext.setPrivateMetadata(discoTransactionContext);
            EventBus.publish(new ThreadEnterEvent("Concurrency", parentThreadId, Thread.currentThread().getId()));
        }
    }

    public static void clear(long ancestralThreadId, long parentThreadId, ConcurrentMap<String, MetadataItem> discoTransactionContext) {
        if (discoTransactionContext == null) {
            return;
        }
        long thisThreadId = Thread.currentThread().getId();
        if (ancestralThreadId != thisThreadId && !ConcurrentUtils.isDiscoNullId(discoTransactionContext)) {
            EventBus.publish(new ThreadExitEvent("Concurrency", parentThreadId, Thread.currentThread().getId()));
            TransactionContext.clear();
        }
    }

    private static boolean isDiscoNullId(ConcurrentMap<String, MetadataItem> discoTransactionContext) {
        MetadataItem item = (MetadataItem)discoTransactionContext.get("$amazon.discoTransactionId");
        if (item == null) {
            return false;
        }
        return TransactionContext.getUninitializedTransactionContextValue().equals(item.get());
    }
}

