/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.agent.web.servlet;

import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.bytebuddy.implementation.bind.annotation.AllArguments;
import net.bytebuddy.implementation.bind.annotation.Origin;
import net.bytebuddy.implementation.bind.annotation.SuperCall;
import net.bytebuddy.implementation.bind.annotation.This;
import software.amazon.disco.agent.concurrent.TransactionContext;
import software.amazon.disco.agent.event.Event;
import software.amazon.disco.agent.event.EventBus;
import software.amazon.disco.agent.event.HttpServletNetworkRequestEvent;
import software.amazon.disco.agent.event.HttpServletNetworkResponseEvent;
import software.amazon.disco.agent.logging.LogManager;
import software.amazon.disco.agent.logging.Logger;
import software.amazon.disco.agent.web.servlet.HttpServletServiceInterceptor;

/*
 * Exception performing whole class analysis ignored.
 */
public class HttpServletServiceMethodDelegation {
    private static final Logger log = LogManager.getLogger(HttpServletServiceInterceptor.class);
    private static final String TX_NAMESPACE = "HTTP_SERVLET_SERVICE";
    private static final String EVENT_ORIGIN = "httpServlet";
    private static final String DATE_HEADER = "date";
    private static final String HOST_HEADER = "host";
    private static final String ORIGIN_HEADER = "origin";
    private static final String REFERER_HEADER = "referer";
    private static final String USER_AGENT_HEADER = "user-agent";

    public static void service(@AllArguments Object[] args, @This Object invoker, @Origin String origin, @SuperCall Callable<Object> zuper) throws Throwable {
        HttpServletNetworkRequestEvent requestEvent = null;
        HttpServletNetworkResponseEvent responseEvent = null;
        Throwable throwable = null;
        if (TransactionContext.isWithinCreatedContext() && TransactionContext.getMetadata((String)"HTTP_SERVLET_SERVICE") != null) {
            zuper.call();
            return;
        }
        TransactionContext.create();
        TransactionContext.putMetadata((String)"HTTP_SERVLET_SERVICE", (Object)true);
        try {
            Object request = args[0];
            HttpServletRequest servletReq = (HttpServletRequest)request;
            int srcPort = servletReq.getRemotePort();
            int dstPort = servletReq.getLocalPort();
            String srcIP = servletReq.getRemoteAddr();
            String dstIP = servletReq.getLocalAddr();
            requestEvent = new HttpServletNetworkRequestEvent("httpServlet", srcPort, dstPort, srcIP, dstIP).withHeaderMap(HttpServletServiceMethodDelegation.retrieveHeaderMap((HttpServletRequest)servletReq)).withDate(servletReq.getHeader("date")).withHost(servletReq.getHeader("host")).withHTTPOrigin(servletReq.getHeader("origin")).withReferer(servletReq.getHeader("referer")).withUserAgent(servletReq.getHeader("user-agent")).withMethod(servletReq.getMethod()).withRequest(request).withURL(servletReq.getRequestURL().toString());
            EventBus.publish((Event)requestEvent);
        }
        catch (Throwable e) {
            log.error("DiSCo(Web) Failed to retrieve request data from servlet service.");
        }
        try {
            zuper.call();
        }
        catch (Throwable t) {
            throwable = t;
        }
        try {
            Object response = args[1];
            HttpServletResponse servletResponse = (HttpServletResponse)response;
            int statusCode = servletResponse.getStatus();
            responseEvent = new HttpServletNetworkResponseEvent("httpServlet", requestEvent).withHeaderMap(HttpServletServiceMethodDelegation.retrieveHeaderMap((HttpServletResponse)servletResponse)).withStatusCode(statusCode).withResponse(response);
            EventBus.publish((Event)responseEvent);
        }
        catch (Throwable t) {
            log.error("DiSCo(Web) Failed to retrieve response data from service.");
        }
        TransactionContext.destroy();
        if (throwable != null) {
            throw throwable;
        }
    }

    static Map<String, String> retrieveHeaderMap(HttpServletRequest servletRequest) {
        HashMap<String, String> ret = new HashMap<String, String>();
        try {
            Enumeration headerNames = servletRequest.getHeaderNames();
            if (headerNames == null) {
                return ret;
            }
            for (String name : Collections.list(headerNames)) {
                ret.put(name, servletRequest.getHeader(name));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ret;
    }

    static Map<String, String> retrieveHeaderMap(HttpServletResponse servletResponse) {
        HashMap<String, String> ret = new HashMap<String, String>();
        try {
            Collection headerNames = servletResponse.getHeaderNames();
            if (headerNames == null) {
                return ret;
            }
            for (String name : headerNames) {
                ret.put(name, servletResponse.getHeader(name));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ret;
    }
}

