/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.agent.web.apache.event;

import software.amazon.disco.agent.event.HttpServiceDownstreamRequestEvent;
import software.amazon.disco.agent.event.HttpServiceDownstreamResponseEvent;
import software.amazon.disco.agent.event.ServiceDownstreamRequestEvent;
import software.amazon.disco.agent.event.ServiceDownstreamResponseEvent;
import software.amazon.disco.agent.web.apache.event.ApacheHttpServiceDownstreamRequestEvent;
import software.amazon.disco.agent.web.apache.utils.HttpRequestAccessor;
import software.amazon.disco.agent.web.apache.utils.HttpRequestBaseAccessor;
import software.amazon.disco.agent.web.apache.utils.HttpResponseAccessor;

public class ApacheEventFactory {
    public static HttpServiceDownstreamRequestEvent createDownstreamRequestEvent(String origin, HttpRequestAccessor accessor) {
        String method;
        String uri;
        if (accessor instanceof HttpRequestBaseAccessor) {
            HttpRequestBaseAccessor baseAccessor = (HttpRequestBaseAccessor)((Object)accessor);
            uri = baseAccessor.getUri();
            method = baseAccessor.getMethod();
        } else {
            uri = accessor.getUriFromRequestLine();
            method = accessor.getMethodFromRequestLine();
        }
        ApacheHttpServiceDownstreamRequestEvent requestEvent = new ApacheHttpServiceDownstreamRequestEvent(origin, uri, method, accessor);
        requestEvent.withMethod(method);
        requestEvent.withUri(uri);
        return requestEvent;
    }

    public static ServiceDownstreamResponseEvent createServiceResponseEvent(HttpResponseAccessor responseAccessor, ServiceDownstreamRequestEvent requestEvent, Throwable throwable) {
        HttpServiceDownstreamResponseEvent responseEvent = new HttpServiceDownstreamResponseEvent(requestEvent.getOrigin(), requestEvent.getService(), requestEvent.getOperation(), requestEvent);
        if (throwable != null) {
            responseEvent.withThrown(throwable);
        }
        if (responseAccessor != null) {
            responseEvent.withStatusCode(responseAccessor.getStatusCode());
            responseEvent.withContentLength(responseAccessor.getContentLength());
        }
        return responseEvent;
    }
}

