/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.agent.web.servlet;

import java.util.concurrent.Callable;
import software.amazon.disco.agent.concurrent.TransactionContext;
import software.amazon.disco.agent.event.Event;
import software.amazon.disco.agent.event.EventBus;
import software.amazon.disco.agent.event.HttpServletNetworkRequestEvent;
import software.amazon.disco.agent.event.HttpServletNetworkResponseEvent;
import software.amazon.disco.agent.interception.Installable;
import software.amazon.disco.agent.jar.bytebuddy.agent.builder.AgentBuilder;
import software.amazon.disco.agent.jar.bytebuddy.description.method.MethodDescription;
import software.amazon.disco.agent.jar.bytebuddy.description.type.TypeDescription;
import software.amazon.disco.agent.jar.bytebuddy.implementation.Implementation;
import software.amazon.disco.agent.jar.bytebuddy.implementation.MethodDelegation;
import software.amazon.disco.agent.jar.bytebuddy.implementation.bind.annotation.AllArguments;
import software.amazon.disco.agent.jar.bytebuddy.implementation.bind.annotation.Origin;
import software.amazon.disco.agent.jar.bytebuddy.implementation.bind.annotation.SuperCall;
import software.amazon.disco.agent.jar.bytebuddy.implementation.bind.annotation.This;
import software.amazon.disco.agent.jar.bytebuddy.matcher.ElementMatcher;
import software.amazon.disco.agent.jar.bytebuddy.matcher.ElementMatchers;
import software.amazon.disco.agent.logging.LogManager;
import software.amazon.disco.agent.logging.Logger;
import software.amazon.disco.agent.web.servlet.HttpServletRequestAccessor;
import software.amazon.disco.agent.web.servlet.HttpServletResponseAccessor;

public class HttpServletServiceInterceptor
implements Installable {
    private static final Logger log = LogManager.getLogger(HttpServletServiceInterceptor.class);
    private static final String TX_NAMESPACE = "HTTP_SERVLET_SERVICE";
    private static final String EVENT_ORIGIN = "httpServlet";
    private static final String DATE_HEADER = "date";
    private static final String HOST_HEADER = "host";
    private static final String ORIGIN_HEADER = "origin";
    private static final String REFERER_HEADER = "referer";
    private static final String USER_AGENT_HEADER = "user-agent";

    public AgentBuilder install(AgentBuilder agentBuilder) {
        return agentBuilder.type(this.buildClassMatcher()).transform((builder, typeDescription, classLoader, module) -> builder.method(this.buildMethodMatcher()).intercept((Implementation)MethodDelegation.to(HttpServletServiceInterceptor.class)));
    }

    public static void service(@AllArguments Object[] args, @This Object invoker, @Origin String origin, @SuperCall Callable<Object> zuper) throws Throwable {
        HttpServletNetworkRequestEvent requestEvent = null;
        HttpServletNetworkResponseEvent responseEvent = null;
        Throwable throwable = null;
        if (LogManager.isDebugEnabled()) {
            log.debug("DiSCo(Web) interception of " + origin);
        }
        if (TransactionContext.isWithinCreatedContext() && TransactionContext.getMetadata((String)TX_NAMESPACE) != null) {
            zuper.call();
            return;
        }
        TransactionContext.create();
        TransactionContext.putMetadata((String)TX_NAMESPACE, (Object)true);
        try {
            Object request = args[0];
            HttpServletRequestAccessor reqAccessor = (HttpServletRequestAccessor)request;
            int srcPort = reqAccessor.getRemotePort();
            int dstPort = reqAccessor.getLocalPort();
            String srcIP = reqAccessor.getRemoteAddr();
            String dstIP = reqAccessor.getLocalAddr();
            requestEvent = new HttpServletNetworkRequestEvent(EVENT_ORIGIN, srcPort, dstPort, srcIP, dstIP).withHeaderMap(reqAccessor.retrieveHeaderMap()).withDate(reqAccessor.getHeader(DATE_HEADER)).withHost(reqAccessor.getHeader(HOST_HEADER)).withHTTPOrigin(reqAccessor.getHeader(ORIGIN_HEADER)).withReferer(reqAccessor.getHeader(REFERER_HEADER)).withUserAgent(reqAccessor.getHeader(USER_AGENT_HEADER)).withMethod(reqAccessor.getMethod()).withRequest(request).withURL(reqAccessor.getRequestUrl());
            EventBus.publish((Event)requestEvent);
        }
        catch (Throwable e) {
            log.error("DiSCo(Web) Failed to retrieve request data from servlet service.");
        }
        try {
            zuper.call();
        }
        catch (Throwable t) {
            throwable = t;
        }
        try {
            Object response = args[1];
            HttpServletResponseAccessor respAccessor = (HttpServletResponseAccessor)response;
            int statusCode = respAccessor.getStatus();
            responseEvent = new HttpServletNetworkResponseEvent(EVENT_ORIGIN, requestEvent).withHeaderMap(respAccessor.retrieveHeaderMap()).withStatusCode(statusCode).withResponse(response);
            EventBus.publish((Event)responseEvent);
        }
        catch (Throwable t) {
            log.error("DiSCo(Web) Failed to retrieve response data from service.");
        }
        TransactionContext.destroy();
        if (throwable != null) {
            throw throwable;
        }
    }

    ElementMatcher<? super TypeDescription> buildClassMatcher() {
        return ElementMatchers.hasSuperType((ElementMatcher)ElementMatchers.named((String)"javax.servlet.http.HttpServlet"));
    }

    ElementMatcher<? super MethodDescription> buildMethodMatcher() {
        ElementMatcher.Junction requestTypeName = ElementMatchers.named((String)"javax.servlet.http.HttpServletRequest");
        ElementMatcher.Junction responseTypeName = ElementMatchers.named((String)"javax.servlet.http.HttpServletResponse");
        ElementMatcher.Junction hasTwoArgs = ElementMatchers.takesArguments((int)2);
        ElementMatcher.Junction firstArgMatches = ElementMatchers.takesArgument((int)0, (ElementMatcher)requestTypeName);
        ElementMatcher.Junction secondArgMatches = ElementMatchers.takesArgument((int)1, (ElementMatcher)responseTypeName);
        ElementMatcher.Junction methodMatches = ElementMatchers.named((String)"service").and((ElementMatcher)hasTwoArgs.and((ElementMatcher)firstArgMatches.and((ElementMatcher)secondArgMatches)));
        return methodMatches.and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isAbstract()));
    }
}

