/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.agent.web.apache.httpclient;

import java.util.concurrent.Callable;
import software.amazon.disco.agent.event.Event;
import software.amazon.disco.agent.event.EventBus;
import software.amazon.disco.agent.event.HttpServiceDownstreamRequestEvent;
import software.amazon.disco.agent.event.ServiceDownstreamRequestEvent;
import software.amazon.disco.agent.event.ServiceDownstreamResponseEvent;
import software.amazon.disco.agent.interception.Installable;
import software.amazon.disco.agent.interception.MethodInterceptionCounter;
import software.amazon.disco.agent.jar.bytebuddy.agent.builder.AgentBuilder;
import software.amazon.disco.agent.jar.bytebuddy.description.method.MethodDescription;
import software.amazon.disco.agent.jar.bytebuddy.description.type.TypeDescription;
import software.amazon.disco.agent.jar.bytebuddy.implementation.Implementation;
import software.amazon.disco.agent.jar.bytebuddy.implementation.MethodDelegation;
import software.amazon.disco.agent.jar.bytebuddy.implementation.bind.annotation.AllArguments;
import software.amazon.disco.agent.jar.bytebuddy.implementation.bind.annotation.Origin;
import software.amazon.disco.agent.jar.bytebuddy.implementation.bind.annotation.RuntimeType;
import software.amazon.disco.agent.jar.bytebuddy.implementation.bind.annotation.SuperCall;
import software.amazon.disco.agent.jar.bytebuddy.matcher.ElementMatcher;
import software.amazon.disco.agent.jar.bytebuddy.matcher.ElementMatchers;
import software.amazon.disco.agent.logging.LogManager;
import software.amazon.disco.agent.logging.Logger;
import software.amazon.disco.agent.web.apache.event.ApacheEventFactory;
import software.amazon.disco.agent.web.apache.utils.HttpRequestAccessor;
import software.amazon.disco.agent.web.apache.utils.HttpResponseAccessor;

public class ApacheHttpClientInterceptor
implements Installable {
    private static final Logger log = LogManager.getLogger(ApacheHttpClientInterceptor.class);
    private static final MethodInterceptionCounter METHOD_INTERCEPTION_COUNTER = new MethodInterceptionCounter();
    static final String APACHE_HTTP_CLIENT_ORIGIN = "ApacheHttpClient";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RuntimeType
    public static Object intercept(@AllArguments Object[] args, @Origin String origin, @SuperCall Callable<Object> zuper) throws Throwable {
        if (LogManager.isDebugEnabled()) {
            log.debug("DiSCo(Web) interception of " + origin);
        }
        if (METHOD_INTERCEPTION_COUNTER.hasIntercepted()) {
            return ApacheHttpClientInterceptor.call(zuper);
        }
        HttpRequestAccessor requestAccessor = ApacheHttpClientInterceptor.findRequestObject(args);
        HttpServiceDownstreamRequestEvent requestEvent = ApacheHttpClientInterceptor.publishRequestEvent(requestAccessor);
        Throwable throwable = null;
        Object response = null;
        try {
            response = ApacheHttpClientInterceptor.call(zuper);
            return response;
        }
        catch (Throwable t) {
            throwable = t;
            return throwable;
        }
        finally {
            HttpResponseAccessor responseAccessor = null;
            if (response instanceof HttpResponseAccessor) {
                responseAccessor = (HttpResponseAccessor)response;
            }
            ApacheHttpClientInterceptor.publishResponseEvent(responseAccessor, (ServiceDownstreamRequestEvent)requestEvent, throwable);
            if (throwable != null) {
                throw throwable;
            }
            return response;
        }
    }

    private static HttpRequestAccessor findRequestObject(Object[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (!HttpRequestAccessor.class.isAssignableFrom(args[i].getClass())) continue;
            return (HttpRequestAccessor)args[i];
        }
        return null;
    }

    private static Object call(Callable<Object> zuper) throws Throwable {
        try {
            METHOD_INTERCEPTION_COUNTER.increment();
            Object object = zuper.call();
            return object;
        }
        finally {
            METHOD_INTERCEPTION_COUNTER.decrement();
        }
    }

    private static HttpServiceDownstreamRequestEvent publishRequestEvent(HttpRequestAccessor requestAccessor) {
        HttpServiceDownstreamRequestEvent requestEvent = ApacheEventFactory.createDownstreamRequestEvent(APACHE_HTTP_CLIENT_ORIGIN, requestAccessor);
        EventBus.publish((Event)requestEvent);
        return requestEvent;
    }

    private static void publishResponseEvent(HttpResponseAccessor responseAccessor, ServiceDownstreamRequestEvent requestEvent, Throwable throwable) {
        ServiceDownstreamResponseEvent responseEvent = ApacheEventFactory.createServiceResponseEvent(responseAccessor, requestEvent, throwable);
        EventBus.publish((Event)responseEvent);
    }

    public AgentBuilder install(AgentBuilder agentBuilder) {
        return agentBuilder.type(ApacheHttpClientInterceptor.buildClassMatcher()).transform((builder, typeDescription, classLoader, module) -> builder.method(ApacheHttpClientInterceptor.buildMethodMatcher(typeDescription)).intercept((Implementation)MethodDelegation.to(this.getClass())));
    }

    static ElementMatcher<? super TypeDescription> buildClassMatcher() {
        ElementMatcher.Junction classMatches = ElementMatchers.hasSuperType((ElementMatcher)ElementMatchers.named((String)"org.apache.http.client.HttpClient"));
        ElementMatcher.Junction notInterfaceMatches = ElementMatchers.not((ElementMatcher)ElementMatchers.isInterface());
        return classMatches.and((ElementMatcher)notInterfaceMatches);
    }

    static ElementMatcher<? super MethodDescription> buildMethodMatcher(TypeDescription typeDescription) {
        ElementMatcher.Junction superTypeIsHttpRequestMatches = ElementMatchers.hasSuperType((ElementMatcher)ElementMatchers.named((String)"org.apache.http.HttpRequest"));
        ElementMatcher.Junction anyArgHasSuperTypeIsHttpRequestMatches = ElementMatchers.hasParameters((ElementMatcher)ElementMatchers.whereAny((ElementMatcher)ElementMatchers.hasType((ElementMatcher)superTypeIsHttpRequestMatches)));
        ElementMatcher.Junction methodMatches = ElementMatchers.named((String)"execute").and((ElementMatcher)anyArgHasSuperTypeIsHttpRequestMatches);
        ElementMatcher.Junction declaredByClass = ElementMatchers.isDeclaredBy((TypeDescription)typeDescription);
        return methodMatches.and((ElementMatcher)declaredByClass).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isAbstract()));
    }
}

