/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.instrumentation.preprocess.loaders.classfiles;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import software.amazon.disco.agent.logging.LogManager;
import software.amazon.disco.agent.logging.Logger;
import software.amazon.disco.instrumentation.preprocess.cli.PreprocessConfig;
import software.amazon.disco.instrumentation.preprocess.exceptions.InstrumentationException;
import software.amazon.disco.instrumentation.preprocess.export.JDKExportStrategy;
import software.amazon.disco.instrumentation.preprocess.instrumentation.InstrumentSignedJarHandlingStrategy;
import software.amazon.disco.instrumentation.preprocess.loaders.classfiles.JarLoader;
import software.amazon.disco.instrumentation.preprocess.loaders.classfiles.SourceInfo;

public class JDKModuleLoader
extends JarLoader {
    private static final Logger log = LogManager.getLogger(JDKModuleLoader.class);

    @Override
    public SourceInfo load(Path path, PreprocessConfig config) {
        log.info("Disco(Instrumentation preprocess) - JDK support option enabled. Attempting to instrument provided JDK runtime");
        if (config.getOutputDir() == null) {
            throw new InstrumentationException("No output dir provided to store instrumented JDK runtime, unable to perform JDK instrumentation", null);
        }
        File jdkModuleFile = this.getJDKBaseModule(path.toString());
        if (this.isJDK9Compatible()) {
            if (jdkModuleFile.getAbsolutePath().endsWith(".jar")) {
                throw new InstrumentationException("Unable to instrument jdk 8 or lower using a JVM that uses the module system.", null);
            }
        } else if (jdkModuleFile.getAbsolutePath().endsWith(".jmod")) {
            throw new InstrumentationException("Unable to instrument jdk 9 or higher using a JVM that doesn't support the module system.", null);
        }
        SourceInfo info = this.loadJar(jdkModuleFile, new JDKExportStrategy(), new InstrumentSignedJarHandlingStrategy());
        return info;
    }

    public File getJDKBaseModule(String javaHome) {
        File javaHomeFile = new File(javaHome);
        if (javaHomeFile.exists()) {
            File jdk9Plus = Paths.get(javaHomeFile.getAbsolutePath(), "jmods", "java.base.jmod").toFile();
            File jdk8Lower = Paths.get(javaHomeFile.getAbsolutePath(), "lib", "rt.jar").toFile();
            if (jdk9Plus.exists()) {
                log.debug("Disco(Instrumentation preprocess) - Java base module for JDK9+ found.");
                return jdk9Plus;
            }
            if (jdk8Lower.exists()) {
                log.debug("Disco(Instrumentation preprocess) - Java base module for JDK8 and lower found.");
                return jdk8Lower;
            }
        }
        throw new InstrumentationException("Unable to retrieve JDK base module from provided path: " + javaHome, null);
    }

    protected boolean isJDK9Compatible() {
        return !System.getProperty("java.version").startsWith("1.");
    }
}

