/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.instrumentation.preprocess.instrumentation;

import java.util.List;
import software.amazon.disco.instrumentation.preprocess.loaders.classfiles.SourceInfo;

public class InstrumentationOutcome {
    private Status status;
    private SourceInfo sourceInfo;
    private String sourcePath;
    private String artifactPath;
    private List<String> failedClasses;

    public boolean hasFailed() {
        return this.failedClasses != null && !this.failedClasses.isEmpty();
    }

    InstrumentationOutcome(Status status, SourceInfo sourceInfo, String sourcePath, String artifactPath, List<String> failedClasses) {
        this.status = status;
        this.sourceInfo = sourceInfo;
        this.sourcePath = sourcePath;
        this.artifactPath = artifactPath;
        this.failedClasses = failedClasses;
    }

    public static InstrumentationOutcomeBuilder builder() {
        return new InstrumentationOutcomeBuilder();
    }

    public Status getStatus() {
        return this.status;
    }

    public SourceInfo getSourceInfo() {
        return this.sourceInfo;
    }

    public String getSourcePath() {
        return this.sourcePath;
    }

    public String getArtifactPath() {
        return this.artifactPath;
    }

    public List<String> getFailedClasses() {
        return this.failedClasses;
    }

    public static class InstrumentationOutcomeBuilder {
        private Status status;
        private SourceInfo sourceInfo;
        private String sourcePath;
        private String artifactPath;
        private List<String> failedClasses;

        InstrumentationOutcomeBuilder() {
        }

        public InstrumentationOutcomeBuilder status(Status status) {
            this.status = status;
            return this;
        }

        public InstrumentationOutcomeBuilder sourceInfo(SourceInfo sourceInfo) {
            this.sourceInfo = sourceInfo;
            return this;
        }

        public InstrumentationOutcomeBuilder sourcePath(String sourcePath) {
            this.sourcePath = sourcePath;
            return this;
        }

        public InstrumentationOutcomeBuilder artifactPath(String artifactPath) {
            this.artifactPath = artifactPath;
            return this;
        }

        public InstrumentationOutcomeBuilder failedClasses(List<String> failedClasses) {
            this.failedClasses = failedClasses;
            return this;
        }

        public InstrumentationOutcome build() {
            return new InstrumentationOutcome(this.status, this.sourceInfo, this.sourcePath, this.artifactPath, this.failedClasses);
        }

        public String toString() {
            return "InstrumentationOutcome.InstrumentationOutcomeBuilder(status=" + (Object)((Object)this.status) + ", sourceInfo=" + this.sourceInfo + ", sourcePath=" + this.sourcePath + ", artifactPath=" + this.artifactPath + ", failedClasses=" + this.failedClasses + ")";
        }
    }

    public static enum Status {
        COMPLETED,
        WARNING_OCCURRED,
        NO_OP;

    }
}

