/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.instrumentation.preprocess.cli;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import software.amazon.disco.agent.logging.Logger;
import software.amazon.disco.instrumentation.preprocess.cli.PreprocessConfig;
import software.amazon.disco.instrumentation.preprocess.exceptions.ArgumentParserException;
import software.amazon.disco.instrumentation.preprocess.exceptions.InvalidConfigEntryException;
import software.amazon.disco.instrumentation.preprocess.instrumentation.InstrumentSignedJarHandlingStrategy;
import software.amazon.disco.instrumentation.preprocess.instrumentation.SignedJarHandlingStrategy;
import software.amazon.disco.instrumentation.preprocess.instrumentation.SkipSignedJarHandlingStrategy;
import software.amazon.disco.instrumentation.preprocess.instrumentation.cache.ChecksumCacheStrategy;
import software.amazon.disco.instrumentation.preprocess.instrumentation.cache.NoOpCacheStrategy;

public class PreprocessConfigParser {
    private static final Map<String, OptionToMatch> ACCEPTED_FLAGS = new HashMap<String, OptionToMatch>();

    public PreprocessConfig parseCommandLine(String[] args) {
        if (args == null || args.length == 0) {
            throw new ArgumentParserException("Mandatory options not supplied, please use [--help] to get a list of all options supported by this CLI.");
        }
        this.setupAcceptedFlags();
        PreprocessConfig.PreprocessConfigBuilder builder = PreprocessConfig.builder();
        LinkedList<String> argsToParse = new LinkedList<String>(Arrays.asList(args));
        OptionToMatch flagBeingMatched = null;
        while (!argsToParse.isEmpty()) {
            String arg = argsToParse.pop().trim();
            String argLowered = arg.toLowerCase();
            if (argLowered.startsWith("@")) {
                argsToParse.addAll(0, this.readArgsFromFile(arg.substring(1)));
                continue;
            }
            if (flagBeingMatched == null) {
                OptionToMatch option = ACCEPTED_FLAGS.get(argLowered);
                if (option == null) {
                    throw new ArgumentParserException("Flag: [" + arg + "] is invalid");
                }
                if (option.hasArgument) {
                    flagBeingMatched = option;
                    continue;
                }
                this.processFlagWithNoArg(argLowered, builder);
                continue;
            }
            if (ACCEPTED_FLAGS.containsKey(argLowered)) {
                throw new ArgumentParserException("Flag: [" + flagBeingMatched.getFlag() + "] requires an argument");
            }
            this.matchArgWithFlag(flagBeingMatched, arg, builder);
            flagBeingMatched = null;
        }
        if (flagBeingMatched != null && !flagBeingMatched.isMatched) {
            throw new ArgumentParserException("Flag: [" + flagBeingMatched.getFlag() + "] requires an argument");
        }
        return builder.build();
    }

    protected void setupAcceptedFlags() {
        ACCEPTED_FLAGS.put("--help", new OptionToMatch("--help", false));
        ACCEPTED_FLAGS.put("--verbose", new OptionToMatch("--verbose", false));
        ACCEPTED_FLAGS.put("--extraverbose", new OptionToMatch("--extraverbose", false));
        ACCEPTED_FLAGS.put("--silent", new OptionToMatch("--silent", false));
        ACCEPTED_FLAGS.put("--failonunresolvabledependency", new OptionToMatch("--failonunresolvabledependency", false));
        ACCEPTED_FLAGS.put("--outputdir", new OptionToMatch("--outputdir", true));
        ACCEPTED_FLAGS.put("--sourcepaths", new OptionToMatch("--sourcepaths", true));
        ACCEPTED_FLAGS.put("--agentpath", new OptionToMatch("--agentpath", true));
        ACCEPTED_FLAGS.put("--suffix", new OptionToMatch("--suffix", true));
        ACCEPTED_FLAGS.put("--javaversion", new OptionToMatch("--javaversion", true));
        ACCEPTED_FLAGS.put("--agentarg", new OptionToMatch("--agentarg", true));
        ACCEPTED_FLAGS.put("--jdksupport", new OptionToMatch("--jdksupport", true));
        ACCEPTED_FLAGS.put("--signedjarhandlingstrategy", new OptionToMatch("--signedjarhandlingstrategy", true));
        ACCEPTED_FLAGS.put("--cachestrategy", new OptionToMatch("--cachestrategy", true));
        ACCEPTED_FLAGS.put("--workers", new OptionToMatch("--workers", true));
        ACCEPTED_FLAGS.put("-out", new OptionToMatch("-out", true));
        ACCEPTED_FLAGS.put("-sps", new OptionToMatch("-sps", true));
        ACCEPTED_FLAGS.put("-ap", new OptionToMatch("-ap", true));
        ACCEPTED_FLAGS.put("-suf", new OptionToMatch("-suf", true));
        ACCEPTED_FLAGS.put("-jv", new OptionToMatch("-jv", true));
        ACCEPTED_FLAGS.put("-arg", new OptionToMatch("-arg", true));
        ACCEPTED_FLAGS.put("-jdks", new OptionToMatch("-jdks", true));
        ACCEPTED_FLAGS.put("-cache", new OptionToMatch("-cache", true));
    }

    protected void matchArgWithFlag(OptionToMatch option, String argument, PreprocessConfig.PreprocessConfigBuilder builder) {
        block20 : switch (option.getFlag().toLowerCase()) {
            case "-out": 
            case "--outputdir": {
                builder.outputDir(argument);
                break;
            }
            case "-sps": 
            case "--sourcepaths": {
                String[] segments = argument.split("@");
                if (segments.length > 2) {
                    throw new InvalidConfigEntryException("Invalid value provided for [sourcePaths]");
                }
                this.addToSourceMap(builder, segments.length == 1 ? "" : segments[1], segments[0].split(":"));
                break;
            }
            case "-ap": 
            case "--agentpath": {
                builder.agentPath(argument);
                break;
            }
            case "-arg": 
            case "--agentarg": {
                builder.agentArg(argument);
                break;
            }
            case "-suf": 
            case "--suffix": {
                builder.suffix(argument);
                break;
            }
            case "-jv": 
            case "--javaversion": {
                builder.javaVersion(argument);
                break;
            }
            case "-jdks": 
            case "--jdksupport": {
                builder.jdkPath(argument);
                break;
            }
            case "-cache": 
            case "--cachestrategy": {
                switch (argument.toLowerCase(Locale.ROOT)) {
                    case "checksum": {
                        builder.cacheStrategy(new ChecksumCacheStrategy());
                        break block20;
                    }
                    case "none": {
                        builder.cacheStrategy(new NoOpCacheStrategy());
                        break block20;
                    }
                }
                throw new InvalidConfigEntryException("Invalid value provided for key [cacheStrategy]");
            }
            case "--signedjarhandlingstrategy": {
                builder.signedJarHandlingStrategy(this.parseSignedJarHandlingStrategyArg(argument));
                break;
            }
            case "--workers": {
                if (!this.isWorkersArgValid(argument)) {
                    throw new InvalidConfigEntryException("Invalid value provided for [workers]");
                }
                builder.subPreprocessors(argument);
                break;
            }
        }
        option.isMatched = true;
    }

    protected void processFlagWithNoArg(String flag, PreprocessConfig.PreprocessConfigBuilder builder) {
        switch (flag.toLowerCase()) {
            case "--help": {
                break;
            }
            case "--verbose": {
                builder.logLevel(Logger.Level.DEBUG);
                break;
            }
            case "--extraverbose": {
                builder.logLevel(Logger.Level.TRACE);
                break;
            }
            case "--silent": {
                builder.logLevel(Logger.Level.FATAL);
                break;
            }
            case "--failonunresolvabledependency": {
                builder.failOnUnresolvableDependency(true);
                break;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<String> readArgsFromFile(String filePath) {
        File file = new File(filePath);
        if (!file.exists()) throw new ArgumentParserException("Invalid response file: " + filePath);
        if (file.isDirectory()) {
            throw new ArgumentParserException("Invalid response file: " + filePath);
        }
        try (BufferedReader br = new BufferedReader(new FileReader(filePath));){
            String line;
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
            List<String> list = Arrays.asList(sb.toString().trim().split("\\s+"));
            return list;
        }
        catch (Throwable t) {
            throw new ArgumentParserException("Failed to read options from response file: " + filePath);
        }
    }

    private void addToSourceMap(PreprocessConfig.PreprocessConfigBuilder builder, String key, String[] sources) {
        Map<String, Set<String>> existingSources = builder.build().getSourcePaths();
        Set<Object> setToAdd = existingSources.containsKey(key) ? existingSources.get(key) : new HashSet();
        for (String source : sources) {
            if (source.isEmpty()) continue;
            setToAdd.add(source);
        }
        if (!existingSources.containsKey(key) && !setToAdd.isEmpty()) {
            builder.sourcePath(key, setToAdd);
        }
    }

    private SignedJarHandlingStrategy parseSignedJarHandlingStrategyArg(String strategy) {
        switch (strategy.toLowerCase(Locale.ROOT)) {
            case "skip": {
                return new SkipSignedJarHandlingStrategy();
            }
            case "instrument": {
                return new InstrumentSignedJarHandlingStrategy();
            }
        }
        throw new InvalidConfigEntryException("Invalid value provided for signedjarhandlingstrategy");
    }

    private boolean isWorkersArgValid(String workers) {
        try {
            int numOfWorkers = Integer.parseInt(workers);
            return numOfWorkers > 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    class OptionToMatch {
        final String flag;
        final boolean hasArgument;
        boolean isMatched;

        public OptionToMatch(String flag, boolean hasArgument, boolean isMatched) {
            this.flag = flag;
            this.hasArgument = hasArgument;
            this.isMatched = isMatched;
        }

        public OptionToMatch(String flag, boolean hasArgument) {
            this.flag = flag;
            this.hasArgument = hasArgument;
        }

        public String getFlag() {
            return this.flag;
        }

        public boolean isHasArgument() {
            return this.hasArgument;
        }

        public boolean isMatched() {
            return this.isMatched;
        }
    }
}

