/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.agent.event;

import java.util.List;
import java.util.Map;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.disco.agent.event.AwsServiceDownstreamEvent;
import software.amazon.disco.agent.event.AwsServiceDownstreamRequestEvent;

public class AwsServiceDownstreamRequestEventImpl
extends AwsServiceDownstreamRequestEvent {
    private SdkHttpRequest sdkHttpRequest;

    public AwsServiceDownstreamRequestEventImpl(String origin, String service, String operation) {
        super(origin, service, operation);
    }

    public SdkHttpRequest getSdkHttpRequest() {
        return this.sdkHttpRequest;
    }

    public AwsServiceDownstreamRequestEvent withRegion(String region) {
        this.withData(AwsServiceDownstreamRequestEvent.DataKey.REGION.name(), (Object)region);
        return this;
    }

    public AwsServiceDownstreamRequestEventImpl withSdkHttpRequest(SdkHttpRequest sdkHttpRequest) {
        this.sdkHttpRequest = sdkHttpRequest;
        return this;
    }

    public AwsServiceDownstreamRequestEventImpl withHeaderMap(Map<String, List<String>> headerMap) {
        this.withData(AwsServiceDownstreamEvent.DataKey.HEADER_MAP.name(), headerMap);
        return this;
    }

    public Object getValueForField(String fieldName, Class clazz) {
        if (!(this.getRequest() instanceof SdkRequest)) {
            return null;
        }
        SdkRequest request = (SdkRequest)this.getRequest();
        return request.getValueForField(fieldName, clazz);
    }

    public boolean replaceHeader(String name, String value) {
        if (this.sdkHttpRequest == null) {
            return false;
        }
        this.sdkHttpRequest = (SdkHttpRequest)((SdkHttpRequest.Builder)this.sdkHttpRequest.toBuilder()).appendHeader(name, value).build();
        this.withHeaderMap(this.sdkHttpRequest.headers());
        return this.getHeaderMap() != null;
    }

    public String getFirstHeader(String key) {
        List headers = this.getHeaders(key);
        return headers != null && !headers.isEmpty() ? (String)headers.get(0) : null;
    }

    public List<String> getHeaders(String key) {
        return (List)this.getAllHeaders().get(key);
    }

    public Map<String, List<String>> getAllHeaders() {
        Map headerMap = (Map)this.getData(AwsServiceDownstreamEvent.DataKey.HEADER_MAP.name());
        return headerMap;
    }
}

