/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.agent.event;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import software.amazon.awssdk.core.SdkResponse;
import software.amazon.awssdk.http.SdkHttpResponse;
import software.amazon.disco.agent.event.AwsServiceDownstreamEvent;
import software.amazon.disco.agent.event.AwsServiceDownstreamRequestEvent;
import software.amazon.disco.agent.event.AwsServiceDownstreamResponseEvent;

public class AwsServiceDownstreamResponseEventImpl
extends AwsServiceDownstreamResponseEvent {
    private SdkHttpResponse sdkHttpResponse;

    public AwsServiceDownstreamResponseEventImpl(AwsServiceDownstreamRequestEvent requestEvent) {
        super(requestEvent.getOrigin(), requestEvent.getService(), requestEvent.getOperation(), requestEvent);
    }

    public AwsServiceDownstreamResponseEventImpl withSdkHttpResponse(SdkHttpResponse sdkHttpResponse) {
        this.sdkHttpResponse = sdkHttpResponse;
        return this;
    }

    public AwsServiceDownstreamResponseEventImpl withRequestId(String requestId) {
        this.withData(AwsServiceDownstreamResponseEvent.DataKey.REQUEST_ID.name(), requestId);
        return this;
    }

    public AwsServiceDownstreamResponseEventImpl withHeaderMap(Map<String, List<String>> headerMap) {
        this.withData(AwsServiceDownstreamEvent.DataKey.HEADER_MAP.name(), headerMap);
        return this;
    }

    public AwsServiceDownstreamResponseEventImpl withRetryCount(int retryCount) {
        this.withData(AwsServiceDownstreamResponseEvent.DataKey.RETRIES.name(), retryCount);
        return this;
    }

    @Override
    public int getStatusCode() {
        if (this.sdkHttpResponse == null) {
            return -1;
        }
        return this.sdkHttpResponse.statusCode();
    }

    @Override
    public Object getValueForField(String fieldName, Class clazz) {
        if (!(this.getResponse() instanceof SdkResponse)) {
            return Optional.empty();
        }
        SdkResponse response = (SdkResponse)this.getResponse();
        return response.getValueForField(fieldName, clazz);
    }
}

