/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.agent.reflect.concurrent;

import java.util.Collections;
import java.util.Map;
import software.amazon.disco.agent.reflect.ReflectiveCall;
import software.amazon.disco.agent.reflect.logging.Logger;

public class TransactionContext {
    static final String DISCO_PREFIX = "$amazon.disco";
    static final String TRANSACTIONCONTEXT_CLASS = ".concurrent.TransactionContext";

    public static int create() {
        return ReflectiveCall.returning(Integer.TYPE).ofClass(TRANSACTIONCONTEXT_CLASS).ofMethod("create").withDefaultValue(0).call(new Object[0]);
    }

    public static void destroy() {
        ReflectiveCall.returningVoid().ofClass(TRANSACTIONCONTEXT_CLASS).ofMethod("destroy").call(new Object[0]);
    }

    public static void set(String value) {
        ReflectiveCall.returningVoid().ofClass(TRANSACTIONCONTEXT_CLASS).ofMethod("set").withArgTypes(String.class).call(value);
    }

    public static String get() {
        return ReflectiveCall.returning(String.class).ofClass(TRANSACTIONCONTEXT_CLASS).ofMethod("get").call(new Object[0]);
    }

    public static void putMetadata(String key, Object value) {
        ReflectiveCall call = ReflectiveCall.returningVoid().ofClass(TRANSACTIONCONTEXT_CLASS).ofMethod("putMetadata").withArgTypes(String.class, Object.class);
        TransactionContext.checkMetadataKey(call, key);
        call.call(key, value);
    }

    public static void removeMetadata(String key) {
        ReflectiveCall call = ReflectiveCall.returningVoid().ofClass(TRANSACTIONCONTEXT_CLASS).ofMethod("removeMetadata").withArgTypes(String.class);
        TransactionContext.checkMetadataKey(call, key);
        call.call(key);
    }

    public static Object getMetadata(String key) {
        ReflectiveCall<Object> call = ReflectiveCall.returning(Object.class).ofClass(TRANSACTIONCONTEXT_CLASS).ofMethod("getMetadata").withArgTypes(String.class);
        TransactionContext.checkMetadataKey(call, key);
        return call.call(key);
    }

    public static void setMetadataTag(String key, String tag) {
        ReflectiveCall.returningVoid().ofClass(TRANSACTIONCONTEXT_CLASS).ofMethod("setMetadataTag").withArgTypes(String.class, String.class).call(key, tag);
    }

    public static Map<String, Object> getMetadataWithTag(String tag) {
        return ReflectiveCall.returning(Map.class).ofClass(TRANSACTIONCONTEXT_CLASS).ofMethod("getMetadataWithTag").withArgTypes(String.class).withDefaultValue(Collections.emptyMap()).call(tag);
    }

    public static void clear() {
        ReflectiveCall.returningVoid().ofClass(TRANSACTIONCONTEXT_CLASS).ofMethod("clear").call(new Object[0]);
    }

    public static String getUninitializedTransactionContextValue() {
        return ReflectiveCall.returning(String.class).ofClass(TRANSACTIONCONTEXT_CLASS).ofMethod("getUninitializedTransactionContextValue").call(new Object[0]);
    }

    public static boolean isWithinCreatedContext() {
        Boolean result = ReflectiveCall.returning(Boolean.class).ofClass(TRANSACTIONCONTEXT_CLASS).ofMethod("isWithinCreatedContext").call(new Object[0]);
        return result == null ? false : result;
    }

    private static void checkMetadataKey(ReflectiveCall call, String key) {
        if (key.startsWith(DISCO_PREFIX)) {
            String message = key + " may not be used as a metadata key as the prefix " + DISCO_PREFIX + " is reserved for internal use";
            Logger.warn(message);
            call.dispatchException(new IllegalArgumentException(message), new Object[0]);
        }
    }
}

