/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.agent.reflect;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import software.amazon.disco.agent.reflect.UncaughtExceptionHandler;
import software.amazon.disco.agent.reflect.logging.Logger;

public class ReflectiveCall<T> {
    private static final String DISCO_AGENT_PACKAGE_ROOT = "software.amazon.disco.agent";
    private static Class templateClass = null;
    private String className;
    private String methodName;
    private Object thiz;
    private Class returnType;
    private Class<?>[] argTypes;
    private T defaultValue;
    private Method method;
    static UncaughtExceptionHandler uncaughtExceptionHandler = null;

    private ReflectiveCall(Class returnType) {
        this.returnType = returnType;
    }

    public static ReflectiveCall returningVoid() {
        return new ReflectiveCall(Void.TYPE);
    }

    public static <T> ReflectiveCall<T> returning(Class<T> clazz) {
        return new ReflectiveCall<T>(clazz);
    }

    public ReflectiveCall<T> withDefaultValue(T defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public ReflectiveCall<T> ofClass(String className) {
        this.className = className;
        return this;
    }

    public ReflectiveCall<T> ofMethod(String methodName) {
        this.methodName = methodName;
        return this;
    }

    public ReflectiveCall<T> onInstance(Object thiz) {
        this.thiz = thiz;
        return this;
    }

    public ReflectiveCall<T> withArgTypes(Class ... argTypes) {
        this.argTypes = argTypes;
        return this;
    }

    public boolean methodFound() {
        if (this.method == null) {
            this.createMethod();
        }
        return this.method != null;
    }

    public T call(Object ... args) {
        String fullClassName = DISCO_AGENT_PACKAGE_ROOT + this.className;
        try {
            if (this.method == null) {
                this.createMethod();
            }
            if (this.method == null) {
                return this.defaultValue;
            }
            return (T)this.method.invoke(this.thiz, args);
        }
        catch (IllegalAccessException e) {
            Logger.warn("IllegalAccessException when trying to call " + fullClassName + ":" + this.methodName);
        }
        catch (InvocationTargetException e) {
            this.dispatchException(e.getCause(), args);
        }
        return null;
    }

    public static boolean isAgentPresent() {
        try {
            if (templateClass == null) {
                templateClass = Class.forName("software.amazon.disco.agent.DiscoAgentTemplate");
            }
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static void installUncaughtExceptionHandler(UncaughtExceptionHandler handler) {
        uncaughtExceptionHandler = handler;
    }

    public void dispatchException(Throwable t, Object ... args) {
        if (uncaughtExceptionHandler != null) {
            uncaughtExceptionHandler.handleUncaughtException(this, args, t);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.returnType.getName() + " " + DISCO_AGENT_PACKAGE_ROOT + this.className + "::" + this.methodName + "(");
        List argTypeNames = Arrays.stream(this.argTypes).map(x -> x.getName()).collect(Collectors.toList());
        builder.append(String.join((CharSequence)", ", argTypeNames));
        builder.append(")");
        return builder.toString();
    }

    public String getClassName() {
        return DISCO_AGENT_PACKAGE_ROOT + this.className;
    }

    public Class getReturnType() {
        return this.returnType;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Class[] getArgTypes() {
        return this.argTypes;
    }

    private void createMethod() {
        String fullClassName = DISCO_AGENT_PACKAGE_ROOT + this.className;
        try {
            Class<?> clazz = Class.forName(fullClassName);
            this.method = clazz.getDeclaredMethod(this.methodName, this.argTypes);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

