/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dax.dynamodb;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinition;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.ConditionCheck;
import software.amazon.awssdk.services.dynamodb.model.Delete;
import software.amazon.awssdk.services.dynamodb.model.Put;
import software.amazon.awssdk.services.dynamodb.model.TransactWriteItem;
import software.amazon.awssdk.services.dynamodb.model.TransactWriteItemsRequest;
import software.amazon.awssdk.services.dynamodb.model.Update;
import software.amazon.dax.channel.RequestEncoder;
import software.amazon.dax.com.amazon.cbor.Encoder;
import software.amazon.dax.com.amazon.cbor.SegmentPool;
import software.amazon.dax.com.amazon.dax.bits.DaxCborOutputStream;
import software.amazon.dax.com.amazon.dax.bits.SegmentPool;
import software.amazon.dax.com.amazon.dax.bits.dynamodb.DynamoNumerals;
import software.amazon.dax.com.amazon.dax.bits.expr.ExpressionType;
import software.amazon.dax.com.amazon.dax.client.dynamodb.DaxRequestEncoder;
import software.amazon.dax.dynamodb.AttributeValueEncoder;
import software.amazon.dax.dynamodb.RefreshingCache;
import software.amazon.dax.dynamodb.RequestValidator;
import software.amazon.dax.dynamodb.SimpleCache;
import software.amazon.dax.exceptions.ExceptionTranslator;
import software.amazon.dax.expr.ExpressionValidationModel;

public class TransactWriteItemsRequestEncoder
extends RequestEncoder<TransactWriteItemsRequest> {
    private static final String TXN_VALIDATION_ERROR_MSG = "transactItems.%d.member.%s.%s";
    private final SegmentPool segmentPool;
    private final RefreshingCache<String, List<AttributeDefinition>> cache;
    private final SimpleCache<List<String>, Long> attributeListIdCache;
    private final AtomicReference<Map<String, List<AttributeDefinition>>> keyDefPerTable;
    private final AtomicReference<List<Map<String, AttributeValue>>> keysPerRequest;

    public TransactWriteItemsRequestEncoder(SegmentPool segmentPool, RefreshingCache<String, List<AttributeDefinition>> cache, SimpleCache<List<String>, Long> attributeListIdCache, AtomicReference<Map<String, List<AttributeDefinition>>> keyDefPerTable, AtomicReference<List<Map<String, AttributeValue>>> keysPerRequest) {
        this.segmentPool = segmentPool;
        this.cache = cache;
        this.attributeListIdCache = attributeListIdCache;
        this.keyDefPerTable = keyDefPerTable;
        this.keysPerRequest = keysPerRequest;
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, TransactWriteItemsRequest request, ChannelPromise promise) throws Exception {
        if (!request.hasTransactItems()) {
            throw ExceptionTranslator.createValidationException("1 validation error detected: Value null at 'transactItems' failed to satisfy constraint: Member must not be null");
        }
        if (request.transactItems().size() < 1) {
            throw ExceptionTranslator.createValidationException("1 validation error detected: Value '" + request.transactItems() + "' at 'transactItems' failed to satisfy constraint: Member must have length greater than or equal to 1");
        }
        int i = 0;
        CompletableFuture[] tableKeysFutures = new CompletableFuture[request.transactItems().size()];
        CompletableFuture[] futures = new CompletableFuture[request.transactItems().size()];
        HashMap tableKeysMap = new HashMap();
        Long[] attributeListIds = new Long[request.transactItems().size()];
        for (TransactWriteItem transactWriteItem : request.transactItems()) {
            if (transactWriteItem == null) {
                throw ExceptionTranslator.createValidationException("1 validation error detected: Value '" + request.transactItems() + "' at 'transactItems' failed to satisfy constraint: Member must not be null");
            }
            String tableName = null;
            String updateExpr = null;
            String conditionExpr = null;
            Object rvOnConditionCheckFailure = null;
            Map key = null;
            Map item = null;
            Map eAttrVal = null;
            Map eAttrName = null;
            String opName = null;
            int operations = 0;
            if (transactWriteItem.conditionCheck() != null) {
                ++operations;
                ConditionCheck check = transactWriteItem.conditionCheck();
                tableName = check.tableName();
                key = check.key();
                conditionExpr = check.conditionExpression();
                if (conditionExpr == null) {
                    throw ExceptionTranslator.createValidationException("Value null at '" + String.format(TXN_VALIDATION_ERROR_MSG, i + 1, "conditionCheck", "conditionExpression") + "' failed to satisfy constraint: Member must not be null");
                }
                eAttrName = check.hasExpressionAttributeNames() ? check.expressionAttributeNames() : null;
                eAttrVal = check.hasExpressionAttributeValues() ? check.expressionAttributeValues() : null;
                opName = "conditionCheck";
            }
            if (transactWriteItem.put() != null) {
                ++operations;
                Put put = transactWriteItem.put();
                tableName = put.tableName();
                item = put.item();
                conditionExpr = put.conditionExpression();
                eAttrName = put.hasExpressionAttributeNames() ? put.expressionAttributeNames() : null;
                eAttrVal = put.hasExpressionAttributeValues() ? put.expressionAttributeValues() : null;
                opName = "put";
            }
            if (transactWriteItem.delete() != null) {
                ++operations;
                Delete delete = transactWriteItem.delete();
                tableName = delete.tableName();
                key = delete.key();
                conditionExpr = delete.conditionExpression();
                eAttrName = delete.hasExpressionAttributeNames() ? delete.expressionAttributeNames() : null;
                eAttrVal = delete.hasExpressionAttributeValues() ? delete.expressionAttributeValues() : null;
                opName = "delete";
            }
            if (transactWriteItem.update() != null) {
                ++operations;
                Update update = transactWriteItem.update();
                tableName = update.tableName();
                key = update.key();
                conditionExpr = update.conditionExpression();
                updateExpr = update.updateExpression();
                if (updateExpr == null) {
                    throw ExceptionTranslator.createValidationException("1 validation error detected: Value null at '" + String.format(TXN_VALIDATION_ERROR_MSG, i + 1, "update", "updateExpression") + "' failed to satisfy constraint: Member must not be null");
                }
                eAttrName = update.hasExpressionAttributeNames() ? update.expressionAttributeNames() : null;
                eAttrVal = update.hasExpressionAttributeValues() ? update.expressionAttributeValues() : null;
                opName = "update";
            }
            if (operations > 1) {
                throw ExceptionTranslator.createValidationException("TransactItems can only contain one of ConditionCheck, Put, Update or Delete");
            }
            if (operations == 0) {
                throw ExceptionTranslator.createValidationException("Invalid Request: TransactWriteRequest should contain Delete or Put or Update request");
            }
            RequestValidator.validateTableName(tableName, String.format(TXN_VALIDATION_ERROR_MSG, i + 1, opName, "tableName"));
            RequestValidator.validateTransactItem(opName.equals("put") ? item : key, String.format(TXN_VALIDATION_ERROR_MSG, i + 1, opName, opName.equals("put") ? "item" : "key"));
            RequestValidator.validateExpression(new ExpressionValidationModel().conditionExpression(conditionExpr).updateExpression(updateExpr).expressionAttributeNames(eAttrName).expressionAttributeValues(eAttrVal));
            Map copyOfItem = item;
            String copyOfTableName = tableName;
            int index = i;
            tableKeysFutures[i] = this.cache.get(copyOfTableName).thenApply(tableKeys -> {
                tableKeysMap.put(copyOfTableName, tableKeys);
                futures[index] = copyOfItem != null ? AttributeValueEncoder.getAttributeListId(copyOfItem, tableKeys, this.attributeListIdCache, attributeListIds, index) : CompletableFuture.completedFuture(-1L);
                return null;
            });
            ++i;
        }
        CompletableFuture.allOf(tableKeysFutures).whenComplete((placeholder0, ex) -> {
            if (ex != null) {
                promise.setFailure(ex);
            } else {
                CompletableFuture.allOf(futures).whenComplete((placeholder, exception) -> {
                    if (exception != null) {
                        promise.setFailure(exception);
                    } else {
                        try {
                            this.encodeAndWrite(ctx, request, promise, tableKeysMap, attributeListIds);
                        }
                        catch (Exception e) {
                            promise.setFailure((Throwable)e);
                        }
                    }
                });
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void encodeAndWrite(ChannelHandlerContext ctx, TransactWriteItemsRequest request, ChannelPromise promise, Map<String, List<AttributeDefinition>> tableKeysMap, Long[] attributeListIds) throws Exception {
        SegmentPool.Segment rvOnConditionCheckTail;
        SegmentPool.Segment conditionExprsTail;
        SegmentPool.Segment updateExprsTail;
        SegmentPool.Segment tableNamesTail;
        SegmentPool.Segment operationsTail;
        SegmentPool.Segment valuesTail;
        SegmentPool.Segment keysTail;
        SegmentPool.Segment singleKeyHead = this.segmentPool.alloc();
        SegmentPool.Segment singleValueHead = this.segmentPool.alloc();
        SegmentPool.Segment keysHead = keysTail = this.segmentPool.alloc();
        SegmentPool.Segment valuesHead = valuesTail = this.segmentPool.alloc();
        SegmentPool.Segment operationsHead = operationsTail = this.segmentPool.alloc();
        SegmentPool.Segment tableNamesHead = tableNamesTail = this.segmentPool.alloc();
        SegmentPool.Segment updateExprsHead = updateExprsTail = this.segmentPool.alloc();
        SegmentPool.Segment conditionExprsHead = conditionExprsTail = this.segmentPool.alloc();
        SegmentPool.Segment rvOnConditionCheckHead = rvOnConditionCheckTail = this.segmentPool.alloc();
        HashMap<String, TreeSet<byte[]>> keySetPerTable = new HashMap<String, TreeSet<byte[]>>();
        this.keyDefPerTable.compareAndSet(null, new HashMap());
        this.keysPerRequest.compareAndSet(null, new ArrayList(request.transactItems().size()));
        ByteBuf buffer = ctx.alloc().buffer();
        DaxCborOutputStream out = new DaxCborOutputStream((OutputStream)new ByteBufOutputStream(buffer), 0);
        try {
            keysTail = this.segmentPool.chainAppendCborArrayPrefix(keysTail, request.transactItems().size());
            valuesTail = this.segmentPool.chainAppendCborArrayPrefix(valuesTail, request.transactItems().size());
            operationsTail = this.segmentPool.chainAppendCborArrayPrefix(operationsTail, request.transactItems().size());
            tableNamesTail = this.segmentPool.chainAppendCborArrayPrefix(tableNamesTail, request.transactItems().size());
            rvOnConditionCheckTail = this.segmentPool.chainAppendCborArrayPrefix(rvOnConditionCheckTail, request.transactItems().size());
            updateExprsTail = this.segmentPool.chainAppendCborArrayPrefix(updateExprsTail, request.transactItems().size());
            conditionExprsTail = this.segmentPool.chainAppendCborArrayPrefix(conditionExprsTail, request.transactItems().size());
            int index = 0;
            for (TransactWriteItem transactWriteItem : request.transactItems()) {
                String tableName = null;
                String updateExpr = null;
                String conditionExpr = null;
                String rvOnConditionCheckFailure = null;
                DynamoNumerals.Operation operation = null;
                Map key = null;
                Map item = null;
                Map eAttrVal = null;
                Map eAttrName = null;
                int operations = 0;
                if (transactWriteItem.conditionCheck() != null) {
                    ++operations;
                    ConditionCheck check = transactWriteItem.conditionCheck();
                    tableName = check.tableName();
                    operation = DynamoNumerals.Operation.CHECK;
                    key = check.key();
                    conditionExpr = check.conditionExpression();
                    eAttrName = check.hasExpressionAttributeNames() ? check.expressionAttributeNames() : null;
                    eAttrVal = check.hasExpressionAttributeValues() ? check.expressionAttributeValues() : null;
                    rvOnConditionCheckFailure = check.returnValuesOnConditionCheckFailureAsString();
                }
                if (transactWriteItem.put() != null) {
                    ++operations;
                    Put put = transactWriteItem.put();
                    tableName = put.tableName();
                    operation = DynamoNumerals.Operation.PUT;
                    item = put.item();
                    conditionExpr = put.conditionExpression();
                    eAttrName = put.hasExpressionAttributeNames() ? put.expressionAttributeNames() : null;
                    eAttrVal = put.hasExpressionAttributeValues() ? put.expressionAttributeValues() : null;
                    rvOnConditionCheckFailure = put.returnValuesOnConditionCheckFailureAsString();
                }
                if (transactWriteItem.delete() != null) {
                    ++operations;
                    Delete delete = transactWriteItem.delete();
                    tableName = delete.tableName();
                    operation = DynamoNumerals.Operation.DELETE;
                    key = delete.key();
                    conditionExpr = delete.conditionExpression();
                    eAttrName = delete.hasExpressionAttributeNames() ? delete.expressionAttributeNames() : null;
                    eAttrVal = delete.hasExpressionAttributeValues() ? delete.expressionAttributeValues() : null;
                    rvOnConditionCheckFailure = delete.returnValuesOnConditionCheckFailureAsString();
                }
                if (transactWriteItem.update() != null) {
                    ++operations;
                    Update update = transactWriteItem.update();
                    tableName = update.tableName();
                    operation = DynamoNumerals.Operation.PARTIAL_UPDATE;
                    key = update.key();
                    conditionExpr = update.conditionExpression();
                    updateExpr = update.updateExpression();
                    eAttrName = update.hasExpressionAttributeNames() ? update.expressionAttributeNames() : null;
                    eAttrVal = update.hasExpressionAttributeValues() ? update.expressionAttributeValues() : null;
                    rvOnConditionCheckFailure = update.returnValuesOnConditionCheckFailureAsString();
                }
                List<AttributeDefinition> tableKeys = tableKeysMap.get(tableName);
                this.keyDefPerTable.get().put(tableName, tableKeys);
                this.keysPerRequest.get().add(TransactWriteItemsRequestEncoder.extractKey(item == null ? key : item, tableKeys));
                if (key != null) {
                    RequestValidator.validateKey(key, tableKeys);
                }
                AttributeValueEncoder.encodeKey(this.segmentPool, singleKeyHead, item == null ? key : item, tableKeys);
                byte[] keyBytes = this.segmentPool.chainCopyAndTrim(singleKeyHead, 0);
                TreeSet<byte[]> keySet = (TreeSet<byte[]>)keySetPerTable.get(tableName);
                if (keySet == null) {
                    keySet = new TreeSet<byte[]>(AttributeValueEncoder.UnsignedComparator.INSTANCE);
                    keySetPerTable.put(tableName, keySet);
                }
                if (!keySet.add(keyBytes)) {
                    throw ExceptionTranslator.createValidationException("Transaction request cannot include multiple operations on one item");
                }
                keysTail = this.segmentPool.chainAppendCborBytes(keysTail, keyBytes);
                if (item != null) {
                    int offset = AttributeValueEncoder.encodeAttributes((Map<String, AttributeValue>)item, tableKeys, attributeListIds[index], this.segmentPool, singleValueHead);
                    valuesTail = this.segmentPool.chainAppendCborBytes(valuesTail, this.segmentPool.chainCopyAndTrim(singleValueHead, offset));
                } else {
                    valuesTail = this.segmentPool.chainAppendCborNull(valuesTail);
                }
                operationsTail = this.segmentPool.chainAppendCborInteger(operationsTail, operation.mCode);
                tableNamesTail = this.segmentPool.chainAppendCborBytes(tableNamesTail, Encoder.encodeUtf8(tableName));
                rvOnConditionCheckTail = rvOnConditionCheckFailure != null ? this.segmentPool.chainAppendCborInteger(rvOnConditionCheckTail, DynamoNumerals.ReturnValueOnConditionCheckFailure.fromName((String)rvOnConditionCheckFailure).mCode) : this.segmentPool.chainAppendCborInteger(rvOnConditionCheckTail, DynamoNumerals.ReturnValueOnConditionCheckFailure.NONE.mCode);
                Map<ExpressionType, byte[]> encodedExprs = AttributeValueEncoder.encodeExpressions(conditionExpr, null, null, updateExpr, null, eAttrName, eAttrVal);
                byte[] condExp = encodedExprs.get((Object)ExpressionType.Condition);
                byte[] updateExp = encodedExprs.get((Object)ExpressionType.Update);
                conditionExprsTail = condExp != null ? this.segmentPool.chainAppendCborBytes(conditionExprsTail, condExp) : this.segmentPool.chainAppendCborNull(conditionExprsTail);
                updateExprsTail = updateExp != null ? this.segmentPool.chainAppendCborBytes(updateExprsTail, updateExp) : this.segmentPool.chainAppendCborNull(updateExprsTail);
                ++index;
            }
            DynamoNumerals.ReturnConsumedCapacity returnConsumedCapacity = DynamoNumerals.ReturnConsumedCapacity.fromName(request.returnConsumedCapacityAsString());
            DynamoNumerals.ReturnItemCollectionMetrics returnItemCollectionMetrics = DynamoNumerals.ReturnItemCollectionMetrics.fromName(request.returnItemCollectionMetricsAsString());
            String clientRequestToken = request.clientRequestToken();
            if (clientRequestToken == null) {
                request = (TransactWriteItemsRequest)request.copy(c -> c.clientRequestToken(UUID.randomUUID().toString()));
                clientRequestToken = request.clientRequestToken();
            }
            byte[] kwargs = DaxRequestEncoder.encodeItemOperationsOptionalParams(DynamoNumerals.ReturnValue.NONE.mCode, returnConsumedCapacity.mCode, returnItemCollectionMetrics.mCode, null, null, clientRequestToken, this.segmentPool);
            out.writeInt(1);
            out.writeInt(-1160037738);
            byte[] operationsBytes = this.segmentPool.chainCopyAndTrim(operationsHead, 0);
            byte[] tableNamesBytes = this.segmentPool.chainCopyAndTrim(tableNamesHead, 0);
            byte[] keysBytes = this.segmentPool.chainCopyAndTrim(keysHead, 0);
            byte[] values = this.segmentPool.chainCopyAndTrim(valuesHead, 0);
            byte[] returnValuesOnConditionCheckFailure = this.segmentPool.chainCopyAndTrim(rvOnConditionCheckHead, 0);
            byte[] conditionExpressions = this.segmentPool.chainCopyAndTrim(conditionExprsHead, 0);
            byte[] updateExpressions = this.segmentPool.chainCopyAndTrim(updateExprsHead, 0);
            out.write(operationsBytes);
            out.write(tableNamesBytes);
            out.write(keysBytes);
            if (values == null) {
                out.writeNull();
            } else {
                out.write(values);
            }
            out.writeNull();
            if (returnValuesOnConditionCheckFailure == null) {
                out.writeNull();
            } else {
                out.write(returnValuesOnConditionCheckFailure);
            }
            if (conditionExpressions == null) {
                out.writeNull();
            } else {
                out.write(conditionExpressions);
            }
            if (updateExpressions == null) {
                out.writeNull();
            } else {
                out.write(updateExpressions);
            }
            if (kwargs == null) {
                out.writeNull();
            } else {
                out.write(kwargs);
            }
            out.flush();
            ctx.writeAndFlush((Object)buffer, promise);
        }
        finally {
            this.segmentPool.recycle(singleKeyHead);
            this.segmentPool.recycle(singleValueHead);
            this.segmentPool.recycle(keysHead);
            this.segmentPool.recycle(valuesHead);
            this.segmentPool.recycle(operationsHead);
            this.segmentPool.recycle(tableNamesHead);
            this.segmentPool.recycle(rvOnConditionCheckHead);
            this.segmentPool.recycle(updateExprsHead);
            this.segmentPool.recycle(conditionExprsHead);
            out.close();
        }
    }

    public static Map<String, AttributeValue> extractKey(Map<String, AttributeValue> item, List<AttributeDefinition> tableKeys) {
        HashMap<String, AttributeValue> keys = new HashMap<String, AttributeValue>();
        for (AttributeDefinition keyDef : tableKeys) {
            String keyName = keyDef.attributeName();
            keys.put(keyName, item.get(keyName));
        }
        return keys;
    }
}

