/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dax.dynamodb;

import java.util.List;
import java.util.Map;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

abstract class PathElement
implements Comparable<PathElement> {
    PathElement() {
    }

    public abstract void append(List<AttributeValue> var1, Map<String, AttributeValue> var2, AttributeValue var3);

    public String fieldName() {
        return null;
    }

    public int fieldIndex() {
        return -1;
    }

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public static PathElement from(String fieldName) {
        if (fieldName == null) {
            throw new IllegalArgumentException("field name must not be null");
        }
        return new MapElement(fieldName);
    }

    public static PathElement from(int fieldIndex) {
        if (fieldIndex < 0) {
            throw new IllegalArgumentException("field index must be >= 0");
        }
        return new ArrayElement(fieldIndex);
    }

    private static final class MapElement
    extends PathElement {
        private final String mName;

        private MapElement(String mName) {
            this.mName = mName;
        }

        @Override
        public void append(List<AttributeValue> l, Map<String, AttributeValue> m, AttributeValue child) {
            m.put(this.mName, child);
        }

        @Override
        public String fieldName() {
            return this.mName;
        }

        @Override
        public int compareTo(PathElement obj) {
            if (this == obj) {
                return 0;
            }
            if (obj == null) {
                return 1;
            }
            String otherName = obj.fieldName();
            if (otherName == null) {
                return -1;
            }
            return this.mName.compareTo(otherName);
        }

        @Override
        public int hashCode() {
            return this.mName.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !(obj instanceof MapElement)) {
                return false;
            }
            MapElement other = (MapElement)obj;
            return this.mName.equals(other.mName);
        }

        public String toString() {
            return this.mName;
        }
    }

    private static final class ArrayElement
    extends PathElement {
        private final int mOffset;

        private ArrayElement(int mOffset) {
            this.mOffset = mOffset;
        }

        @Override
        public void append(List<AttributeValue> l, Map<String, AttributeValue> m, AttributeValue child) {
            l.add(child);
        }

        @Override
        public int fieldIndex() {
            return this.mOffset;
        }

        @Override
        public int hashCode() {
            return this.mOffset;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !(obj instanceof ArrayElement)) {
                return false;
            }
            ArrayElement other = (ArrayElement)obj;
            return this.mOffset == other.mOffset;
        }

        @Override
        public int compareTo(PathElement obj) {
            if (this == obj) {
                return 0;
            }
            if (obj == null) {
                return 1;
            }
            int otherOffset = obj.fieldIndex();
            return Integer.compare(this.mOffset, otherOffset);
        }

        public String toString() {
            return String.valueOf(this.mOffset);
        }
    }
}

