/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dax.exceptions;

import io.netty.channel.Channel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import software.amazon.awssdk.core.exception.RetryableException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.CancellationReason;
import software.amazon.awssdk.services.dynamodb.model.TransactionCanceledException;
import software.amazon.dax.com.amazon.dax.bits.DaxCborInputStream;
import software.amazon.dax.dynamodb.AttributeValueDecoder;
import software.amazon.dax.dynamodb.DocumentPath;
import software.amazon.dax.dynamodb.SimpleCache;
import software.amazon.dax.exceptions.DaxServiceException;
import software.amazon.dax.exceptions.DaxTransactionCanceledException;
import software.amazon.dax.exceptions.ExceptionTranslator;
import software.amazon.dax.exceptions.MalformedResultException;

public final class ExceptionHandler {
    private ExceptionHandler() {
    }

    public static SdkException handleException(Throwable e, Channel ch) {
        try {
            throw e;
        }
        catch (DaxServiceException dse) {
            return ExceptionTranslator.translateException(dse);
        }
        catch (SdkException se) {
            if (ch != null) {
                ch.close();
            }
            return se;
        }
        catch (IllegalArgumentException iae) {
            if (ch != null) {
                ch.close();
            }
            return ExceptionTranslator.createValidationException(iae.getMessage());
        }
        catch (CompletionException ie) {
            return ExceptionHandler.handleException(ie.getCause(), ch);
        }
        catch (Throwable ioe) {
            if (ch != null) {
                ch.close();
            }
            return RetryableException.create((String)"", (Throwable)ioe);
        }
    }

    public static void handleTransactionException(CompletableFuture<?> completableFuture, Throwable txe, Channel ch, List<Map<String, AttributeValue>> keys, SimpleCache<Long, List<String>> mAttrListCache) {
        SdkException ex = ExceptionHandler.handleException(txe, ch);
        if (ex instanceof TransactionCanceledException && txe instanceof DaxTransactionCanceledException) {
            DaxTransactionCanceledException tce = (DaxTransactionCanceledException)((Object)txe);
            try {
                int requestLength = keys.size();
                if (tce.getReasonCodes().length != requestLength) {
                    throw new MalformedResultException("Cancellation reasons must be the same length as transact write items in the request");
                }
                ArrayList cancellationReasons = new ArrayList(requestLength);
                DaxCborInputStream reasonItemsStream = new DaxCborInputStream(tce.getReasonItems());
                CompletableFuture[] futures = new CompletableFuture[requestLength];
                for (int i = 0; i < requestLength; ++i) {
                    int index = i;
                    futures[i] = AttributeValueDecoder.decodeValue(reasonItemsStream, new HashMap<Integer, DocumentPath>(), mAttrListCache).thenApply(item -> {
                        if (item != null) {
                            item.putAll((Map)keys.get(index));
                        }
                        cancellationReasons.add((CancellationReason)CancellationReason.builder().code(tce.getReasonCodes()[index]).message(tce.getReasonMsgs()[index]).item(item).build());
                        return null;
                    });
                }
                CompletableFuture.allOf(futures).whenComplete((placeholder, unhandledException) -> {
                    if (unhandledException != null) {
                        completableFuture.completeExceptionally(ExceptionHandler.handleException(unhandledException, ch));
                    } else {
                        TransactionCanceledException e = (TransactionCanceledException)((TransactionCanceledException)ex).toBuilder().cancellationReasons((Collection)cancellationReasons).build();
                        completableFuture.completeExceptionally((Throwable)e);
                    }
                });
            }
            catch (Throwable t) {
                completableFuture.completeExceptionally(ExceptionHandler.handleException(t, ch));
            }
        } else {
            completableFuture.completeExceptionally(ex);
        }
    }
}

