/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dax.exceptions;

import java.io.IOException;
import java.util.List;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.dax.com.amazon.cbor.CborInputStream;
import software.amazon.dax.com.amazon.cbor.SegmentOutputStream;
import software.amazon.dax.com.amazon.dax.bits.SegmentPool;
import software.amazon.dax.exceptions.DaxTransactionCanceledException;
import software.amazon.dax.exceptions.MalformedResultException;

public class DaxServiceException
extends AwsServiceException {
    private final String errorMessage;
    private final int[] codeSeq;
    private boolean isRetryable;
    private static final int[] NO_ERROR_CODES = new int[0];
    private static final SegmentPool POOL = SegmentPool.withCapacity(1024);

    public DaxServiceException(String errorMessage, String requestId, String errorCode, int statusCode, int[] codeSeq, boolean isRetryable) {
        super(AwsServiceException.builder().requestId(requestId).statusCode(statusCode).message(DaxServiceException.formatMessage(errorMessage, codeSeq)).awsErrorDetails(AwsErrorDetails.builder().errorCode(errorCode).errorMessage(DaxServiceException.formatMessage(errorMessage, codeSeq)).build()));
        this.errorMessage = errorMessage;
        this.codeSeq = codeSeq;
        this.isRetryable = isRetryable;
    }

    public DaxServiceException(Exception t, boolean isRetryable) {
        super(AwsServiceException.builder().message(t.getMessage()).cause((Throwable)t).statusCode(-1));
        this.errorMessage = t.getMessage();
        this.codeSeq = null;
        this.isRetryable = isRetryable;
    }

    public DaxServiceException(String errMessage, String errorCode) {
        super(AwsServiceException.builder().message(errMessage).statusCode(-1).awsErrorDetails(AwsErrorDetails.builder().errorCode(errorCode).errorMessage(errMessage).build()));
        this.errorMessage = errMessage;
        this.codeSeq = null;
        this.isRetryable = false;
    }

    public int[] getCodeSeq() {
        return this.codeSeq == null ? NO_ERROR_CODES : this.codeSeq;
    }

    public boolean isAuthenticationException() {
        return this.codeSeq.length >= 4 && this.codeSeq[1] == 23 && this.codeSeq[2] == 31;
    }

    private static String formatMessage(String errorMessage, int[] codeSeq) {
        CharSequence[] codeSeqStrs = new String[codeSeq.length];
        for (int i = 0; i < codeSeq.length; ++i) {
            codeSeqStrs[i] = Integer.toString(codeSeq[i]);
        }
        return String.format("[%s] %s", String.join((CharSequence)".", codeSeqStrs), errorMessage);
    }

    public static DaxServiceException pickException(CborInputStream input) throws IOException {
        Object errCodesObj = input.readObject();
        if (errCodesObj == null) {
            throw new MalformedResultException("Response cannot be null", null);
        }
        if (!(errCodesObj instanceof List)) {
            throw new MalformedResultException("Response header must be an array", errCodesObj);
        }
        List codeSeqList = (List)errCodesObj;
        if (codeSeqList.size() == 0) {
            return null;
        }
        int[] errCodes = new int[codeSeqList.size()];
        for (int i = 0; i < codeSeqList.size(); ++i) {
            Object errCodeObj = codeSeqList.get(i);
            if (errCodeObj == null || !(errCodeObj instanceof Number)) {
                throw new MalformedResultException("Error codes must be non-null integers", errCodeObj);
            }
            int errCode = ((Number)errCodeObj).intValue();
            if (!errCodeObj.equals(errCode)) {
                throw new MalformedResultException("Error codes must be in integer range", errCodeObj);
            }
            errCodes[i] = errCode;
        }
        Object messageObj = input.readObject();
        if (messageObj == null || !(messageObj instanceof String)) {
            throw new MalformedResultException("Expected non-null string", messageObj);
        }
        String message = (String)messageObj;
        String requestId = null;
        String errorCode = null;
        int statusCode = -1;
        String[] cancellationReasonCodes = null;
        String[] cancellationReasonMsgs = null;
        byte[] cancellationReasonItems = null;
        if (input.fieldType() != 246) {
            int length = input.readArrayLength();
            if (length != 3 && length != 4) {
                throw new MalformedResultException("Expected 3 or 4 elements in the exception info", length);
            }
            requestId = (String)input.readObject();
            errorCode = (String)input.readObject();
            statusCode = input.readInt();
            if (length == 4) {
                int cancellationReasonsLength = input.readArrayLength() / 3;
                cancellationReasonCodes = new String[cancellationReasonsLength];
                cancellationReasonMsgs = new String[cancellationReasonsLength];
                SegmentOutputStream out = new SegmentOutputStream(POOL);
                for (int i = 0; i < cancellationReasonsLength; ++i) {
                    cancellationReasonCodes[i] = (String)input.readObject();
                    cancellationReasonMsgs[i] = (String)input.readObject();
                    input.readRawObject(out);
                }
                cancellationReasonItems = out.toByteArray();
                out.close();
            }
        } else {
            input.skipObject();
        }
        boolean isRetryable = DaxServiceException.determineRetryable(errCodes);
        if (cancellationReasonCodes != null && cancellationReasonCodes.length > 0) {
            return new DaxTransactionCanceledException(message, requestId, errorCode, statusCode, errCodes, isRetryable).reasonCodes(cancellationReasonCodes).reasonMessages(cancellationReasonMsgs).reasonItems(cancellationReasonItems);
        }
        return new DaxServiceException(message, requestId, errorCode, statusCode, errCodes, isRetryable);
    }

    private static boolean determineRetryable(int[] errCodes) {
        return errCodes.length >= 1 && errCodes[0] == 1 || errCodes[0] == 2 || DaxServiceException.isAuthCRequiredException(errCodes);
    }

    private static boolean isAuthCRequiredException(int[] errCodes) {
        return errCodes.length == 4 && errCodes[0] == 4 && errCodes[1] == 23 && errCodes[2] == 31 && errCodes[3] == 33;
    }
}

