/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dax.dynamodb;

import java.util.AbstractMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import software.amazon.dax.dynamodb.SimpleCache;
import software.amazon.dax.utils.LazyClock;

public class RefreshingCache<K, V> {
    private final SimpleCache<K, Map.Entry<V, Long>> mCache;
    private final LazyClock mClock;
    private final long mTimeToLive;

    public RefreshingCache(int size, Function<K, CompletableFuture<V>> fetcher, long timeToLiveMillis) {
        this(size, fetcher, timeToLiveMillis, LazyClock.instance());
    }

    RefreshingCache(int size, Function<K, CompletableFuture<V>> fetcher, long timeToLive, LazyClock clock) {
        this.mCache = this.createCache(size, fetcher);
        this.mClock = clock;
        this.mTimeToLive = timeToLive;
    }

    public CompletableFuture<V> get(K key) {
        return this.mCache.get(key).thenCompose(innerValue -> {
            if (innerValue == null || (Long)innerValue.getValue() + this.mTimeToLive < this.mClock.getCurrentTime()) {
                this.mCache.remove(key);
                return this.mCache.get(key).thenApply(Map.Entry::getKey);
            }
            return CompletableFuture.completedFuture(innerValue.getKey());
        });
    }

    private SimpleCache<K, Map.Entry<V, Long>> createCache(int size, final Function<K, CompletableFuture<V>> fetcher) {
        return new SimpleCache<K, Map.Entry<V, Long>>(size){

            @Override
            protected CompletableFuture<Map.Entry<V, Long>> fetch(K key) {
                return ((CompletableFuture)fetcher.apply(key)).thenApply(v -> new AbstractMap.SimpleEntry<Object, Long>(v, RefreshingCache.this.mClock.getCurrentTime()));
            }
        };
    }
}

