/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dax.channel;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelOption;
import io.netty.channel.pool.ChannelHealthChecker;
import io.netty.channel.pool.ChannelPool;
import io.netty.channel.pool.ChannelPoolHandler;
import io.netty.channel.pool.FixedChannelPool;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.SupportedCipherSuiteFilter;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import javax.net.ssl.SSLException;
import software.amazon.dax.Configuration;
import software.amazon.dax.InternalConfiguration;
import software.amazon.dax.channel.ChannelPipelineInitializer;
import software.amazon.dax.channel.HandlerRemovingChannelPool;
import software.amazon.dax.channel.HonorCloseOnReleaseChannelPool;
import software.amazon.dax.channel.ReleaseOnceChannelPool;

public class DaxChannelPool
implements ChannelPool {
    private final ChannelPool delegatePool;
    private final ChannelPipelineInitializer channelPipelineInitializer;
    private final FixedChannelPool fixedChannelPool;

    public DaxChannelPool(Configuration configuration, InternalConfiguration internalConfiguration) throws SSLException {
        Bootstrap b = ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(configuration.eventLoopGroup())).channelFactory(NioSocketChannel::new)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)configuration.connectTimeoutMillis())).option(ChannelOption.SO_KEEPALIVE, (Object)true)).option(ChannelOption.TCP_NODELAY, (Object)true)).remoteAddress(configuration.host(), configuration.port());
        SslProvider sslProvider = SslContext.defaultClientProvider();
        SslContext sslCtx = configuration.ssl() ? SslContextBuilder.forClient().protocols(new String[]{"TLSv1.3", "TLSv1.2"}).sslProvider(sslProvider).ciphers(null, (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE).trustManager(internalConfiguration.needCertValidation() ? null : InsecureTrustManagerFactory.INSTANCE).build() : null;
        this.channelPipelineInitializer = new ChannelPipelineInitializer(sslCtx, sslProvider, configuration, internalConfiguration);
        this.fixedChannelPool = new FixedChannelPool(b, (ChannelPoolHandler)this.channelPipelineInitializer, ChannelHealthChecker.ACTIVE, FixedChannelPool.AcquireTimeoutAction.FAIL, (long)configuration.connectTimeoutMillis(), configuration.maxConcurrency(), configuration.maxPendingConnectionAcquires());
        Object channelPool = new HonorCloseOnReleaseChannelPool((ChannelPool)this.fixedChannelPool);
        channelPool = new ReleaseOnceChannelPool((ChannelPool)channelPool);
        channelPool = new HandlerRemovingChannelPool((ChannelPool)channelPool);
        this.delegatePool = channelPool;
    }

    public Future<Channel> acquire() {
        return this.delegatePool.acquire();
    }

    public Future<Channel> acquire(Promise<Channel> promise) {
        return this.delegatePool.acquire(promise);
    }

    public Future<Void> release(Channel channel) {
        return this.delegatePool.release(channel);
    }

    public Future<Void> release(Channel channel, Promise<Void> promise) {
        return this.delegatePool.release(channel, promise);
    }

    public int acquiredChannelCount() {
        return this.fixedChannelPool.acquiredChannelCount();
    }

    public void close() {
        this.delegatePool.close();
    }

    public int size() {
        return this.channelPipelineInitializer.size();
    }
}

