/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dax;

import io.netty.channel.pool.ChannelPool;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinition;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.BatchGetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.BatchGetItemResponse;
import software.amazon.awssdk.services.dynamodb.model.BatchWriteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.BatchWriteItemResponse;
import software.amazon.awssdk.services.dynamodb.model.DeleteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.DeleteItemResponse;
import software.amazon.awssdk.services.dynamodb.model.GetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.GetItemResponse;
import software.amazon.awssdk.services.dynamodb.model.PutItemRequest;
import software.amazon.awssdk.services.dynamodb.model.PutItemResponse;
import software.amazon.awssdk.services.dynamodb.model.QueryRequest;
import software.amazon.awssdk.services.dynamodb.model.QueryResponse;
import software.amazon.awssdk.services.dynamodb.model.ScanRequest;
import software.amazon.awssdk.services.dynamodb.model.ScanResponse;
import software.amazon.awssdk.services.dynamodb.model.TransactGetItemsRequest;
import software.amazon.awssdk.services.dynamodb.model.TransactGetItemsResponse;
import software.amazon.awssdk.services.dynamodb.model.TransactWriteItemsRequest;
import software.amazon.awssdk.services.dynamodb.model.TransactWriteItemsResponse;
import software.amazon.awssdk.services.dynamodb.model.UpdateItemRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateItemResponse;
import software.amazon.dax.Configuration;
import software.amazon.dax.InternalConfiguration;
import software.amazon.dax.channel.DaxChannelPool;
import software.amazon.dax.channel.RequestExecutor;
import software.amazon.dax.com.amazon.dax.bits.SegmentPool;
import software.amazon.dax.com.amazon.dax.bits.disco.ServiceEndpoint;
import software.amazon.dax.dynamodb.BatchGetItemRequestEncoder;
import software.amazon.dax.dynamodb.BatchGetItemResponseHandler;
import software.amazon.dax.dynamodb.BatchWriteItemRequestEncoder;
import software.amazon.dax.dynamodb.BatchWriteItemResponseHandler;
import software.amazon.dax.dynamodb.DefineAttributeListEncoder;
import software.amazon.dax.dynamodb.DefineAttributeListIdEncoder;
import software.amazon.dax.dynamodb.DefineAttributeListIdResponseHandler;
import software.amazon.dax.dynamodb.DefineAttributeListResponseHandler;
import software.amazon.dax.dynamodb.DefineKeySchemaEncoder;
import software.amazon.dax.dynamodb.DefineKeySchemaResponseHandler;
import software.amazon.dax.dynamodb.DeleteItemRequestEncoder;
import software.amazon.dax.dynamodb.DeleteItemResponseHandler;
import software.amazon.dax.dynamodb.DocumentPath;
import software.amazon.dax.dynamodb.EndpointsRequestEncoder;
import software.amazon.dax.dynamodb.EndpointsResponseHandler;
import software.amazon.dax.dynamodb.GetItemRequestEncoder;
import software.amazon.dax.dynamodb.GetItemResponseHandler;
import software.amazon.dax.dynamodb.PutItemRequestEncoder;
import software.amazon.dax.dynamodb.PutItemResponseHandler;
import software.amazon.dax.dynamodb.QueryRequestEncoder;
import software.amazon.dax.dynamodb.QueryResponseHandler;
import software.amazon.dax.dynamodb.RefreshingCache;
import software.amazon.dax.dynamodb.ScanRequestEncoder;
import software.amazon.dax.dynamodb.ScanResponseHandler;
import software.amazon.dax.dynamodb.SimpleCache;
import software.amazon.dax.dynamodb.TransactGetItemsRequestEncoder;
import software.amazon.dax.dynamodb.TransactGetItemsResponseHandler;
import software.amazon.dax.dynamodb.TransactWriteItemsRequestEncoder;
import software.amazon.dax.dynamodb.TransactWriteItemsResponseHandler;
import software.amazon.dax.dynamodb.UpdateItemRequestEncoder;
import software.amazon.dax.dynamodb.UpdateItemResponseHandler;

public class DaxAsyncClient
implements DynamoDbAsyncClient {
    private final RequestExecutor requestExecutor;
    private final ChannelPool channelPool;
    private final SegmentPool segmentPool;
    private final SimpleCache<Long, List<String>> attrListCache;
    private final SimpleCache<List<String>, Long> attrListIdCache;
    private final RefreshingCache<String, List<AttributeDefinition>> tableCache;
    private static final int CACHE_SIZE = 1000;
    private static final long KEY_CACHE_TTL_MILLIS = 60000L;

    public DaxAsyncClient(Configuration configuration, InternalConfiguration internalConfiguration) throws IOException {
        this.channelPool = new DaxChannelPool(configuration, internalConfiguration);
        this.requestExecutor = new RequestExecutor(this.channelPool, configuration, internalConfiguration);
        this.segmentPool = SegmentPool.withCapacity(1024);
        this.attrListCache = new SimpleCache<Long, List<String>>(1000){

            @Override
            protected CompletableFuture<List<String>> fetch(Long key) {
                return DaxAsyncClient.this.defineAttributeList(key);
            }
        };
        this.attrListIdCache = new SimpleCache<List<String>, Long>(1000){

            @Override
            protected CompletableFuture<Long> fetch(List<String> key) {
                return DaxAsyncClient.this.defineAttributeListId(key);
            }
        };
        this.tableCache = new RefreshingCache(1000, key -> this.defineKeySchema((String)key), 60000L);
    }

    public String serviceName() {
        return "dax";
    }

    public void close() {
        this.channelPool.close();
    }

    public CompletableFuture<BatchGetItemResponse> batchGetItem(BatchGetItemRequest batchGetItemRequest) {
        CompletableFuture<BatchGetItemResponse> completableFuture = new CompletableFuture<BatchGetItemResponse>();
        AtomicReference<Map<String, Map<Integer, DocumentPath>>> tableProjOrdinals = new AtomicReference<Map<String, Map<Integer, DocumentPath>>>();
        AtomicReference<Map<String, List<AttributeDefinition>>> keysPerTable = new AtomicReference<Map<String, List<AttributeDefinition>>>();
        this.requestExecutor.execute(new BatchGetItemRequestEncoder(this.segmentPool, this.tableCache, tableProjOrdinals, keysPerTable), new BatchGetItemResponseHandler(completableFuture, this.attrListCache, tableProjOrdinals, keysPerTable, batchGetItemRequest), () -> batchGetItemRequest);
        return completableFuture;
    }

    public CompletableFuture<BatchWriteItemResponse> batchWriteItem(BatchWriteItemRequest batchWriteItemRequest) {
        CompletableFuture<BatchWriteItemResponse> completableFuture = new CompletableFuture<BatchWriteItemResponse>();
        AtomicReference<Map<String, Map<Integer, DocumentPath>>> tableProjOrdinals = new AtomicReference<Map<String, Map<Integer, DocumentPath>>>();
        AtomicReference<Map<String, List<AttributeDefinition>>> keysPerTable = new AtomicReference<Map<String, List<AttributeDefinition>>>();
        this.requestExecutor.execute(new BatchWriteItemRequestEncoder(this.segmentPool, this.tableCache, this.attrListIdCache, tableProjOrdinals, keysPerTable), new BatchWriteItemResponseHandler(completableFuture, this.attrListCache, tableProjOrdinals, keysPerTable, batchWriteItemRequest), () -> batchWriteItemRequest);
        return completableFuture;
    }

    private CompletableFuture<List<String>> defineAttributeList(Long attributeListId) {
        if (attributeListId == 1L) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        CompletableFuture<List<String>> completableFuture = new CompletableFuture<List<String>>();
        this.requestExecutor.execute(new DefineAttributeListEncoder(), new DefineAttributeListResponseHandler(completableFuture), () -> attributeListId);
        return completableFuture;
    }

    private CompletableFuture<List<AttributeDefinition>> defineKeySchema(String tableName) {
        CompletableFuture<List<AttributeDefinition>> completableFuture = new CompletableFuture<List<AttributeDefinition>>();
        this.requestExecutor.execute(new DefineKeySchemaEncoder(), new DefineKeySchemaResponseHandler(completableFuture), () -> tableName);
        return completableFuture;
    }

    private CompletableFuture<Long> defineAttributeListId(List<String> attributeNames) {
        if (attributeNames.isEmpty()) {
            return CompletableFuture.completedFuture(1L);
        }
        CompletableFuture<Long> completableFuture = new CompletableFuture<Long>();
        this.requestExecutor.execute(new DefineAttributeListIdEncoder(), new DefineAttributeListIdResponseHandler(completableFuture), () -> attributeNames);
        return completableFuture;
    }

    public CompletableFuture<DeleteItemResponse> deleteItem(DeleteItemRequest deleteItemRequest) {
        CompletableFuture<DeleteItemResponse> completableFuture = new CompletableFuture<DeleteItemResponse>();
        this.requestExecutor.execute(new DeleteItemRequestEncoder(this.segmentPool, this.tableCache), new DeleteItemResponseHandler(completableFuture, this.tableCache, this.attrListCache, deleteItemRequest), () -> deleteItemRequest);
        return completableFuture;
    }

    public CompletableFuture<List<ServiceEndpoint>> endpoints() {
        CompletableFuture<List<ServiceEndpoint>> completableFuture = new CompletableFuture<List<ServiceEndpoint>>();
        this.requestExecutor.execute(new EndpointsRequestEncoder(), new EndpointsResponseHandler(completableFuture), () -> (byte)0);
        return completableFuture;
    }

    public CompletableFuture<GetItemResponse> getItem(GetItemRequest getItemRequest) {
        CompletableFuture<GetItemResponse> completableFuture = new CompletableFuture<GetItemResponse>();
        AtomicReference<Map<Integer, DocumentPath>> projectionOrdinals = new AtomicReference<Map<Integer, DocumentPath>>();
        this.requestExecutor.execute(new GetItemRequestEncoder(this.segmentPool, this.tableCache, projectionOrdinals), new GetItemResponseHandler(completableFuture, this.attrListCache, projectionOrdinals, getItemRequest), () -> getItemRequest);
        return completableFuture;
    }

    public CompletableFuture<PutItemResponse> putItem(PutItemRequest putItemRequest) {
        CompletableFuture<PutItemResponse> completableFuture = new CompletableFuture<PutItemResponse>();
        this.requestExecutor.execute(new PutItemRequestEncoder(this.segmentPool, this.tableCache, this.attrListIdCache), new PutItemResponseHandler(completableFuture, this.tableCache, this.attrListCache, putItemRequest), () -> putItemRequest);
        return completableFuture;
    }

    public CompletableFuture<QueryResponse> query(QueryRequest queryRequest) {
        CompletableFuture<QueryResponse> completableFuture = new CompletableFuture<QueryResponse>();
        AtomicReference<Map<Integer, DocumentPath>> projectionOrdinals = new AtomicReference<Map<Integer, DocumentPath>>();
        AtomicReference<String> indexName = new AtomicReference<String>();
        this.requestExecutor.execute(new QueryRequestEncoder(this.segmentPool, this.tableCache, projectionOrdinals, indexName), new QueryResponseHandler(completableFuture, this.tableCache, this.attrListCache, projectionOrdinals, indexName, queryRequest), () -> queryRequest);
        return completableFuture;
    }

    public CompletableFuture<ScanResponse> scan(ScanRequest scanRequest) {
        CompletableFuture<ScanResponse> completableFuture = new CompletableFuture<ScanResponse>();
        AtomicReference<Map<Integer, DocumentPath>> projectionOrdinals = new AtomicReference<Map<Integer, DocumentPath>>();
        AtomicReference<String> indexName = new AtomicReference<String>();
        this.requestExecutor.execute(new ScanRequestEncoder(this.segmentPool, this.tableCache, projectionOrdinals, indexName), new ScanResponseHandler(completableFuture, this.tableCache, this.attrListCache, projectionOrdinals, indexName, scanRequest), () -> scanRequest);
        return completableFuture;
    }

    public CompletableFuture<TransactGetItemsResponse> transactGetItems(TransactGetItemsRequest transactGetItemsRequest) {
        CompletableFuture<TransactGetItemsResponse> completableFuture = new CompletableFuture<TransactGetItemsResponse>();
        AtomicReference<List<Map<Integer, DocumentPath>>> projectionOrdinalsPerRequest = new AtomicReference<List<Map<Integer, DocumentPath>>>();
        AtomicReference<Map<String, List<AttributeDefinition>>> keyDefPerTable = new AtomicReference<Map<String, List<AttributeDefinition>>>();
        AtomicReference<List<Map<String, AttributeValue>>> keysPerRequest = new AtomicReference<List<Map<String, AttributeValue>>>();
        this.requestExecutor.execute(new TransactGetItemsRequestEncoder(this.segmentPool, this.tableCache, projectionOrdinalsPerRequest, keyDefPerTable, keysPerRequest), new TransactGetItemsResponseHandler(completableFuture, this.attrListCache, projectionOrdinalsPerRequest, keysPerRequest, keyDefPerTable, transactGetItemsRequest), () -> transactGetItemsRequest);
        return completableFuture;
    }

    public CompletableFuture<TransactWriteItemsResponse> transactWriteItems(TransactWriteItemsRequest transactWriteItemsRequest) {
        CompletableFuture<TransactWriteItemsResponse> completableFuture = new CompletableFuture<TransactWriteItemsResponse>();
        AtomicReference<Map<String, List<AttributeDefinition>>> keyDefPerTable = new AtomicReference<Map<String, List<AttributeDefinition>>>();
        AtomicReference<List<Map<String, AttributeValue>>> keysPerRequest = new AtomicReference<List<Map<String, AttributeValue>>>();
        this.requestExecutor.execute(new TransactWriteItemsRequestEncoder(this.segmentPool, this.tableCache, this.attrListIdCache, keyDefPerTable, keysPerRequest), new TransactWriteItemsResponseHandler(completableFuture, keyDefPerTable, keysPerRequest, this.attrListCache, transactWriteItemsRequest), () -> transactWriteItemsRequest);
        return completableFuture;
    }

    public CompletableFuture<UpdateItemResponse> updateItem(UpdateItemRequest updateItemRequest) {
        CompletableFuture<UpdateItemResponse> completableFuture = new CompletableFuture<UpdateItemResponse>();
        this.requestExecutor.execute(new UpdateItemRequestEncoder(this.segmentPool, this.tableCache), new UpdateItemResponseHandler(completableFuture, this.tableCache, this.attrListCache, updateItemRequest), () -> updateItemRequest);
        return completableFuture;
    }
}

