/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dax.dynamodb;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.io.OutputStream;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinition;
import software.amazon.awssdk.services.dynamodb.model.BatchGetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.KeysAndAttributes;
import software.amazon.dax.channel.RequestEncoder;
import software.amazon.dax.com.amazon.cbor.SegmentPool;
import software.amazon.dax.com.amazon.dax.Constants;
import software.amazon.dax.com.amazon.dax.bits.DaxCborOutputStream;
import software.amazon.dax.com.amazon.dax.bits.SegmentPool;
import software.amazon.dax.com.amazon.dax.bits.dynamodb.DynamoNumerals;
import software.amazon.dax.com.amazon.dax.client.dynamodb.DaxRequestEncoder;
import software.amazon.dax.dynamodb.AttributeValueEncoder;
import software.amazon.dax.dynamodb.DocumentPath;
import software.amazon.dax.dynamodb.DynamoDBExpressionInfo;
import software.amazon.dax.dynamodb.DynamoDBV1Converter;
import software.amazon.dax.dynamodb.RefreshingCache;
import software.amazon.dax.dynamodb.RequestValidator;

public class BatchGetItemRequestEncoder
extends RequestEncoder<BatchGetItemRequest> {
    private final SegmentPool segmentPool;
    private final RefreshingCache<String, List<AttributeDefinition>> cache;
    private final AtomicReference<Map<String, Map<Integer, DocumentPath>>> tableProjOrdinals;
    private final AtomicReference<Map<String, List<AttributeDefinition>>> keysPerTable;

    public BatchGetItemRequestEncoder(SegmentPool segmentPool, RefreshingCache<String, List<AttributeDefinition>> cache, AtomicReference<Map<String, Map<Integer, DocumentPath>>> tableProjOrdinals, AtomicReference<Map<String, List<AttributeDefinition>>> keysPerTable) {
        this.segmentPool = segmentPool;
        this.cache = cache;
        this.tableProjOrdinals = tableProjOrdinals;
        this.keysPerTable = keysPerTable;
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, BatchGetItemRequest request, ChannelPromise promise) throws Exception {
        RequestValidator.validate(request);
        Map requestByTable = request.requestItems();
        HashMap tableKeysMap = new HashMap();
        CompletableFuture[] futures = new CompletableFuture[requestByTable.size()];
        int count = 0;
        for (Map.Entry tableAndRequest : requestByTable.entrySet()) {
            String tableName = (String)tableAndRequest.getKey();
            futures[count] = this.cache.get(tableName).thenApply(tableKeys -> {
                tableKeysMap.put((String)tableAndRequest.getKey(), tableKeys);
                return null;
            });
            ++count;
        }
        CompletableFuture.allOf(futures).whenComplete((placeholder, ex) -> {
            if (ex != null) {
                promise.setFailure(ex);
            } else {
                try {
                    this.encodeAndWrite(ctx, request, tableKeysMap, requestByTable, promise);
                }
                catch (Exception exception) {
                    promise.setFailure((Throwable)exception);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void encodeAndWrite(ChannelHandlerContext ctx, BatchGetItemRequest request, Map<String, List<AttributeDefinition>> tableKeyMap, Map<String, KeysAndAttributes> requestByTable, ChannelPromise promise) throws Exception {
        SegmentPool.Segment requestHead;
        SegmentPool.Segment requestTail = requestHead = this.segmentPool.alloc();
        SegmentPool.Segment keyHead = this.segmentPool.alloc();
        TreeSet<byte[]> keySet = new TreeSet<byte[]>(AttributeValueEncoder.UnsignedComparator.INSTANCE);
        this.tableProjOrdinals.compareAndSet(null, new HashMap());
        this.keysPerTable.compareAndSet(null, new HashMap());
        ByteBuf buffer = ctx.alloc().buffer();
        DaxCborOutputStream out = new DaxCborOutputStream((OutputStream)new ByteBufOutputStream(buffer), 0);
        try {
            requestTail = this.segmentPool.chainAppendCborMapPrefix(requestTail, requestByTable.size());
            for (Map.Entry<String, KeysAndAttributes> tableAndRequest : requestByTable.entrySet()) {
                Map<String, String> expressionAttributeNames;
                String tableName = tableAndRequest.getKey();
                KeysAndAttributes kaas = tableAndRequest.getValue();
                requestTail = this.segmentPool.chainAppendCborString(requestTail, tableName);
                requestTail = this.segmentPool.chainAppendCborArrayPrefix(requestTail, 3);
                requestTail = kaas.consistentRead() == null || kaas.consistentRead() == false ? this.segmentPool.chainAppend(requestTail, (byte)-12) : this.segmentPool.chainAppend(requestTail, (byte)-11);
                DynamoDBExpressionInfo exp = null;
                exp = DynamoDBV1Converter.isV1Request(kaas) ? DynamoDBV1Converter.convertV1RequestToV2(kaas) : new DynamoDBExpressionInfo(kaas);
                String projectionExpression = exp.getProjectionExpression();
                byte[] proj = AttributeValueEncoder.encodeProjection(projectionExpression, expressionAttributeNames = exp.getExpressionAttributeNames());
                if (proj != null) {
                    HashMap<Integer, DocumentPath> projOrdinals = new HashMap<Integer, DocumentPath>();
                    AttributeValueEncoder.prepareProjection(exp, projOrdinals);
                    requestTail = this.segmentPool.chainAppendCborBytes(requestTail, proj);
                    this.tableProjOrdinals.get().put(tableName, projOrdinals);
                } else {
                    requestTail = this.segmentPool.chainAppend(requestTail, (byte)-10);
                }
                List keys = !kaas.hasKeys() ? Collections.emptyList() : kaas.keys();
                requestTail = this.segmentPool.chainAppendCborArrayPrefix(requestTail, keys.size());
                List<AttributeDefinition> tableKeys = tableKeyMap.get(tableName);
                this.keysPerTable.get().put(tableName, tableKeys);
                keySet.clear();
                for (Map key : keys) {
                    AttributeValueEncoder.validateAndEncodeKey(this.segmentPool, keyHead, key, tableKeys);
                    byte[] encodedKey = this.segmentPool.chainCopyAndTrim(keyHead, 0);
                    if (!keySet.add(encodedKey)) {
                        throw new IllegalArgumentException("Provided list of item keys contains duplicates");
                    }
                    requestTail = this.segmentPool.chainAppendCborBytes(requestTail, encodedKey);
                }
            }
            byte[] kwargs = null;
            DynamoNumerals.ReturnConsumedCapacity returnConsumedCapacity = DynamoNumerals.ReturnConsumedCapacity.fromName(request.returnConsumedCapacityAsString());
            EnumMap<Constants.DaxDataRequestParam, Integer> optionalArgs = null;
            if (returnConsumedCapacity.mCode != DynamoNumerals.ReturnConsumedCapacity.NONE.mCode) {
                optionalArgs = new EnumMap<Constants.DaxDataRequestParam, Integer>(Constants.DaxDataRequestParam.class);
                optionalArgs.put(Constants.DaxDataRequestParam.ReturnConsumedCapacity, returnConsumedCapacity.mCode);
            }
            kwargs = DaxRequestEncoder.encodeOptionalArgs(optionalArgs, this.segmentPool);
            out.writeInt(1);
            out.writeInt(-697851100);
            out.write(this.segmentPool.chainCopyAndTrim(requestHead, 0));
            if (kwargs == null) {
                out.writeNull();
            } else {
                out.write(kwargs);
            }
            out.flush();
            ctx.writeAndFlush((Object)buffer, promise);
        }
        finally {
            this.segmentPool.recycle(keyHead);
            this.segmentPool.recycle(requestHead);
            out.close();
        }
    }
}

