/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.codeguruprofilerjavaagent.profile.metadata;

import com.amazon.ion.IonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.Duration;
import java.util.Map;
import software.amazon.codeguruprofilerjavaagent.profile.IonUtils;

public class SamplingMetadata {
    private BigDecimal sampleWeight;
    private Duration samplingDuration;
    private AgentOverhead agentOverhead;
    private Duration cpuTime;
    private Map<String, Integer> numUnscaledSamples;
    private double avgNumThreads;
    private Long numTimesSampled;

    public SamplingMetadata(BigDecimal sampleWeight, Duration samplingDuration, AgentOverhead agentOverhead, Duration cpuTime, double avgNumThreads, Map<String, Integer> numUnscaledSamples, Long numTimesSampled) {
        this.sampleWeight = sampleWeight;
        this.samplingDuration = samplingDuration;
        this.agentOverhead = agentOverhead;
        this.cpuTime = cpuTime;
        this.avgNumThreads = avgNumThreads;
        this.numUnscaledSamples = numUnscaledSamples;
        this.numTimesSampled = numTimesSampled;
    }

    public BigDecimal getSampleWeight() {
        return this.sampleWeight;
    }

    public Duration getSamplingDuration() {
        return this.samplingDuration;
    }

    public AgentOverhead getAgentOverhead() {
        return this.agentOverhead;
    }

    public Duration getCpuTime() {
        return this.cpuTime;
    }

    public double getAvgNumThreads() {
        return this.avgNumThreads;
    }

    public Map<String, Integer> getNumUnscaledSamples() {
        return this.numUnscaledSamples;
    }

    public Long getNumTimesSampled() {
        return this.numTimesSampled;
    }

    public static class AgentOverhead {
        private final Duration time;
        private final long memoryInMB;

        public AgentOverhead(Duration time, long memoryInMB) {
            this.time = time;
            this.memoryInMB = memoryInMB;
        }

        public void write(IonWriter out, String fieldName) throws IOException {
            IonUtils.writeStruct(out, fieldName, () -> {
                IonUtils.writeInt(out, "timeInMs", this.time.toMillis());
                IonUtils.writeInt(out, "memoryInMB", this.memoryInMB);
            });
        }

        public Duration getTime() {
            return this.time;
        }

        public long getMemoryInMB() {
            return this.memoryInMB;
        }
    }
}

