/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.codeguruprofilerjavaagent.profile.metadata;

import com.amazon.ion.IonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.Duration;
import java.util.Map;
import software.amazon.codeguruprofilerjavaagent.profile.IonUtils;
import software.amazon.codeguruprofilerjavaagent.profile.metadata.AgentMetadata;
import software.amazon.codeguruprofilerjavaagent.profile.metadata.SamplingMetadata;

public class AgentMetadataIonWriter {
    private AgentMetadataIonWriter() {
    }

    public static void write(IonWriter out, AgentMetadata agentMetadata, SamplingMetadata samplingMetadata) throws IOException {
        IonUtils.writeStruct(out, () -> {
            IonUtils.writeDecimal(out, "sampleWeightInSeconds", samplingMetadata.getSampleWeight());
            IonUtils.writeInt(out, "durationInMs", samplingMetadata.getSamplingDuration().toMillis());
            if (agentMetadata.getFleetInfo().isPresent()) {
                out.setFieldName("fleetInfo");
                agentMetadata.getFleetInfo().get().write(out);
            }
            agentMetadata.getAgentInfo().write(out, "agentInfo");
            agentMetadata.getCodeInfo().write(out, "codeInfo");
            samplingMetadata.getAgentOverhead().write(out, "agentOverhead");
            if (samplingMetadata.getNumTimesSampled() != null) {
                IonUtils.writeInt(out, "numTimesSampled", samplingMetadata.getNumTimesSampled());
            }
            IonUtils.writeString(out, "runtimeVersion", agentMetadata.getRuntimeVersion());
            if (samplingMetadata.getCpuTime() != Duration.ZERO) {
                IonUtils.writeDecimal(out, "cpuTimeInSeconds", new BigDecimal(samplingMetadata.getCpuTime().toMillis()).divide(new BigDecimal(1000)));
            }
            if (!samplingMetadata.getNumUnscaledSamples().isEmpty()) {
                IonUtils.writeStruct(out, "numUnscaledSamples", () -> {
                    for (Map.Entry<String, Integer> entry : samplingMetadata.getNumUnscaledSamples().entrySet()) {
                        IonUtils.writeInt(out, entry.getKey(), entry.getValue().intValue());
                    }
                });
            }
            IonUtils.writeStruct(out, "metrics", () -> IonUtils.writeDecimal(out, "numThreads", new BigDecimal(samplingMetadata.getAvgNumThreads())));
        });
    }
}

