/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.codeguruprofilerjavaagent.jvmagent;

import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.logging.Logger;
import lombok.Generated;

public enum ProfilingArguments {
    PROFILING_GROUP_NAME("profilingGroupName", "AWS_CODEGURU_PROFILER_GROUP_NAME"),
    PROFILING_GROUP_ARN("profilingGroupArn", "AWS_CODEGURU_PROFILER_GROUP_ARN"),
    CREDENTIAL_PATH("credentialPath", "AWS_CODEGURU_PROFILER_CREDENTIAL_PATH"),
    REGION("region", "AWS_CODEGURU_PROFILER_TARGET_REGION"),
    PROFILER_ENABLED("profilerEnabled", "AWS_CODEGURU_PROFILER_ENABLED"),
    HEAP_SUMMARY_ENABLED("heapSummaryEnabled", "AWS_CODEGURU_PROFILER_HEAP_SUMMARY_ENABLED");

    private static final Logger LOG;
    final String commandLineKey;
    final String environmentVariableName;

    private ProfilingArguments(String commandLineKey, String environmentVariableName) {
        this.environmentVariableName = environmentVariableName;
        this.commandLineKey = commandLineKey;
    }

    Optional<String> readArgument(Map<String, String> commandLineArguments, Function<String, String> environment) {
        String value = commandLineArguments.get(this.commandLineKey);
        String envValue = environment.apply(this.environmentVariableName);
        if (value != null && envValue != null) {
            LOG.info("Profiler agent found both command line argument " + this.commandLineKey + " and environment variable " + this.environmentVariableName + ". Command line argument is used.");
        }
        return Optional.ofNullable(value != null ? value : envValue);
    }

    Optional<String> readArgument(Function<String, String> environment) {
        String envValue = environment.apply(this.environmentVariableName);
        if (envValue != null) {
            LOG.info(String.format("Profiler agent found environment variable %s, using it.", this.environmentVariableName));
        }
        return Optional.ofNullable(envValue);
    }

    @Generated
    public String getCommandLineKey() {
        return this.commandLineKey;
    }

    @Generated
    public String getEnvironmentVariableName() {
        return this.environmentVariableName;
    }

    static {
        LOG = Logger.getLogger(ProfilingArguments.class.getName());
    }
}

