/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.codeguruprofilerjavaagent;

import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.codeguruprofiler.model.ComputePlatform;
import software.amazon.codeguruprofilerjavaagent.CodeGuruProfilerSDKClient;
import software.amazon.codeguruprofilerjavaagent.CodeGuruProfilerSDKClientOverrideConfiguration;
import software.amazon.codeguruprofilerjavaagent.profile.metadata.AgentMetadata;
import software.amazon.codeguruprofilerjavaagent.profile.metadata.ErrorsMetadata;
import software.amazon.codeguruprofilerjavaagent.profile.metadata.FleetInfo;

class CodeGuruProfilerSDKClientProvider {
    private final String profilingGroupName;
    private final String computePlatform;
    private final AwsCredentialsProvider awsCredentialsProvider;
    private final Region awsRegion;
    private final ErrorsMetadata errorsMetadata;
    private final AgentMetadata agentMetadata;
    private CodeGuruProfilerSDKClient client;

    public CodeGuruProfilerSDKClient getClient() {
        if (this.client == null) {
            String fleetInstanceId = this.agentMetadata.getFleetInfo().map(FleetInfo::getFleetInstanceId).orElse("");
            String computePlatform = this.computePlatform == null ? ComputePlatform.DEFAULT.toString() : this.computePlatform;
            this.client = new CodeGuruProfilerSDKClient(this.profilingGroupName, fleetInstanceId, computePlatform, this.awsCredentialsProvider, this.awsRegion, CodeGuruProfilerSDKClientOverrideConfiguration.DEFAULT, this.errorsMetadata);
        }
        return this.client;
    }

    CodeGuruProfilerSDKClientProvider(String profilingGroupName, String computePlatform, AwsCredentialsProvider awsCredentialsProvider, Region awsRegion, ErrorsMetadata errorsMetadata, AgentMetadata agentMetadata, CodeGuruProfilerSDKClient client) {
        this.profilingGroupName = profilingGroupName;
        this.computePlatform = computePlatform;
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.awsRegion = awsRegion;
        this.errorsMetadata = errorsMetadata;
        this.agentMetadata = agentMetadata;
        this.client = client;
    }

    public static CodeGuruProfilerSDKClientProviderBuilder builder() {
        return new CodeGuruProfilerSDKClientProviderBuilder();
    }

    public static class CodeGuruProfilerSDKClientProviderBuilder {
        private String profilingGroupName;
        private String computePlatform;
        private AwsCredentialsProvider awsCredentialsProvider;
        private Region awsRegion;
        private ErrorsMetadata errorsMetadata;
        private AgentMetadata agentMetadata;
        private CodeGuruProfilerSDKClient client;

        public Region getAwsRegion() {
            return this.awsRegion;
        }

        public AwsCredentialsProvider getAwsCredentialsProvider() {
            return this.awsCredentialsProvider;
        }

        CodeGuruProfilerSDKClientProviderBuilder() {
        }

        public CodeGuruProfilerSDKClientProviderBuilder profilingGroupName(String profilingGroupName) {
            this.profilingGroupName = profilingGroupName;
            return this;
        }

        public CodeGuruProfilerSDKClientProviderBuilder computePlatform(String computePlatform) {
            this.computePlatform = computePlatform;
            return this;
        }

        public CodeGuruProfilerSDKClientProviderBuilder awsCredentialsProvider(AwsCredentialsProvider awsCredentialsProvider) {
            this.awsCredentialsProvider = awsCredentialsProvider;
            return this;
        }

        public CodeGuruProfilerSDKClientProviderBuilder awsRegion(Region awsRegion) {
            this.awsRegion = awsRegion;
            return this;
        }

        public CodeGuruProfilerSDKClientProviderBuilder errorsMetadata(ErrorsMetadata errorsMetadata) {
            this.errorsMetadata = errorsMetadata;
            return this;
        }

        public CodeGuruProfilerSDKClientProviderBuilder agentMetadata(AgentMetadata agentMetadata) {
            this.agentMetadata = agentMetadata;
            return this;
        }

        public CodeGuruProfilerSDKClientProviderBuilder client(CodeGuruProfilerSDKClient client) {
            this.client = client;
            return this;
        }

        public CodeGuruProfilerSDKClientProvider build() {
            return new CodeGuruProfilerSDKClientProvider(this.profilingGroupName, this.computePlatform, this.awsCredentialsProvider, this.awsRegion, this.errorsMetadata, this.agentMetadata, this.client);
        }

        public String toString() {
            return "CodeGuruProfilerSDKClientProvider.CodeGuruProfilerSDKClientProviderBuilder(profilingGroupName=" + this.profilingGroupName + ", computePlatform=" + this.computePlatform + ", awsCredentialsProvider=" + this.awsCredentialsProvider + ", awsRegion=" + this.awsRegion + ", errorsMetadata=" + this.errorsMetadata + ", agentMetadata=" + this.agentMetadata + ", client=" + this.client + ")";
        }
    }
}

