/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.codeguruprofilerjavaagent;

import java.io.ByteArrayOutputStream;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.codeguruprofiler.CodeGuruProfilerClient;
import software.amazon.awssdk.services.codeguruprofiler.CodeGuruProfilerClientBuilder;
import software.amazon.awssdk.services.codeguruprofiler.model.AgentConfiguration;
import software.amazon.awssdk.services.codeguruprofiler.model.ComputePlatform;
import software.amazon.awssdk.services.codeguruprofiler.model.ConfigureAgentRequest;
import software.amazon.awssdk.services.codeguruprofiler.model.ConfigureAgentResponse;
import software.amazon.awssdk.services.codeguruprofiler.model.ConflictException;
import software.amazon.awssdk.services.codeguruprofiler.model.CreateProfilingGroupRequest;
import software.amazon.awssdk.services.codeguruprofiler.model.CreateProfilingGroupResponse;
import software.amazon.awssdk.services.codeguruprofiler.model.PostAgentProfileRequest;
import software.amazon.awssdk.services.codeguruprofiler.model.ProfilingGroupDescription;
import software.amazon.awssdk.services.codeguruprofiler.model.ResourceNotFoundException;
import software.amazon.awssdk.services.codeguruprofiler.model.ValidationException;
import software.amazon.codeguruprofilerjavaagent.AgentOrchestrator;
import software.amazon.codeguruprofilerjavaagent.ProfileReporter;
import software.amazon.codeguruprofilerjavaagent.ProfilingGroupManager;
import software.amazon.codeguruprofilerjavaagent.profile.Profile;
import software.amazon.codeguruprofilerjavaagent.profile.ProfileIonKeys;
import software.amazon.codeguruprofilerjavaagent.profile.ProfileIonSerializer;
import software.amazon.codeguruprofilerjavaagent.profile.metadata.ErrorsMetadata;

class CodeGuruProfilerSDKClient
implements AgentOrchestrator,
ProfileReporter<Profile>,
ProfilingGroupManager {
    private static final Logger LOG = Logger.getLogger(CodeGuruProfilerSDKClient.class.getName());
    private static final int INTERVAL_ON_RESOURCE_NOT_FOUND = 300;
    private final String fleetInstanceId;
    private final String computePlatform;
    private final CodeGuruProfilerClient client;
    private final String profilingGroupName;
    private final ProfileIonSerializer serializer;
    private final ErrorsMetadata errorsMetadata;

    CodeGuruProfilerSDKClient(String profilingGroupName, String fleetInstanceId, String computePlatform, AwsCredentialsProvider awsCredentialsProvider, Region awsRegion, ClientOverrideConfiguration clientOverrideConfiguration, ErrorsMetadata errorsMetadata) {
        this(profilingGroupName, fleetInstanceId, computePlatform, (CodeGuruProfilerClient)((CodeGuruProfilerClientBuilder)((CodeGuruProfilerClientBuilder)((CodeGuruProfilerClientBuilder)((CodeGuruProfilerClientBuilder)CodeGuruProfilerClient.builder().credentialsProvider(awsCredentialsProvider)).region(awsRegion)).overrideConfiguration(clientOverrideConfiguration)).httpClientBuilder((SdkHttpClient.Builder)ApacheHttpClient.builder())).build(), errorsMetadata);
    }

    CodeGuruProfilerSDKClient(String profilingGroupName, String fleetInstanceId, String computePlatform, CodeGuruProfilerClient client, ErrorsMetadata errorsMetadata) {
        this.profilingGroupName = profilingGroupName;
        this.fleetInstanceId = fleetInstanceId;
        this.computePlatform = computePlatform;
        this.client = client;
        this.serializer = new ProfileIonSerializer();
        this.errorsMetadata = errorsMetadata;
    }

    @Override
    public Optional<AgentConfiguration> configureAgent() {
        return this.configureAgent(null);
    }

    @Override
    public Optional<AgentConfiguration> configureAgent(Map<String, String> configureAgentMetadata) {
        try {
            ConfigureAgentResponse response;
            ConfigureAgentRequest.Builder configureAgentRequestBuilder = ConfigureAgentRequest.builder().profilingGroupName(this.profilingGroupName).fleetInstanceId(this.fleetInstanceId);
            if (configureAgentMetadata != null && !configureAgentMetadata.isEmpty()) {
                configureAgentRequestBuilder.metadataWithStrings(configureAgentMetadata);
            }
            if ((response = this.client.configureAgent((ConfigureAgentRequest)configureAgentRequestBuilder.build())) != null && response.configuration() != null) {
                return Optional.of(response.configuration());
            }
        }
        catch (ResourceNotFoundException e) {
            if (this.shouldAutoCreateProfilingGroup()) {
                this.errorsMetadata.recordSdk(LOG, Level.INFO, String.format("Profiling group not found. Will try to create a profiling group with name = %s and compute platform = %s and retry calling configure agent after 5 minutes, Make sure Lambda's execution role has AmazonCodeGuruProfilerAgentAccess policy added.", this.profilingGroupName, this.computePlatform), null, ProfileIonKeys.SDK_ERROR_TYPE.CONFIGURE_AGENT_RNFE_AUTO_CREATE_ENABLED_ERRORS);
                this.createProfilingGroup();
                return Optional.of(AgentConfiguration.builder().shouldProfile(Boolean.valueOf(true)).periodInSeconds(Integer.valueOf(300)).build());
            }
            this.errorsMetadata.recordSdk(LOG, Level.INFO, "Profiling group not found. Will retry after 5 minutes.", null, ProfileIonKeys.SDK_ERROR_TYPE.CONFIGURE_AGENT_ERRORS);
            return Optional.of(AgentConfiguration.builder().shouldProfile(Boolean.valueOf(false)).periodInSeconds(Integer.valueOf(300)).build());
        }
        catch (ValidationException e) {
            LOG.log(Level.INFO, "Validation exception received while configuring the agent. Profiling will be stopped");
            throw e;
        }
        catch (Exception e) {
            this.errorsMetadata.recordSdk(LOG, Level.INFO, "Exception while calling agent orchestration.", e, ProfileIonKeys.SDK_ERROR_TYPE.CONFIGURE_AGENT_ERRORS);
        }
        return Optional.empty();
    }

    @Override
    public boolean report(Profile profile) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.serializer.serialize(profile, baos);
            baos.close();
            this.client.postAgentProfile((PostAgentProfileRequest)PostAgentProfileRequest.builder().profilingGroupName(this.profilingGroupName).agentProfile(SdkBytes.fromByteArray((byte[])baos.toByteArray())).contentType("application/octet-stream").build());
            return true;
        }
        catch (ResourceNotFoundException rnfe) {
            if (this.shouldAutoCreateProfilingGroup()) {
                this.errorsMetadata.recordSdk(LOG, Level.INFO, String.format("Profiling group not found. Will try to create a profiling group with name = %s and compute platform = %s and retry reporting profile during next invocation. Make sure Lambda's execution role has AmazonCodeGuruProfilerAgentAccess policy added.", this.profilingGroupName, this.computePlatform), null, ProfileIonKeys.SDK_ERROR_TYPE.POST_AGENT_PROFILE_RNFE_AUTO_CREATE_ENABLED_ERRORS);
                this.createProfilingGroup();
                throw rnfe;
            }
            this.errorsMetadata.recordSdk(LOG, Level.INFO, "Exception while reporting profile.", (Exception)((Object)rnfe), ProfileIonKeys.SDK_ERROR_TYPE.POST_AGENT_PROFILE_ERRORS);
        }
        catch (Exception e) {
            this.errorsMetadata.recordSdk(LOG, Level.INFO, "Exception while reporting profile.", e, ProfileIonKeys.SDK_ERROR_TYPE.POST_AGENT_PROFILE_ERRORS);
        }
        return false;
    }

    @Override
    public Optional<ProfilingGroupDescription> createProfilingGroup() {
        try {
            CreateProfilingGroupResponse response = this.client.createProfilingGroup((CreateProfilingGroupRequest)CreateProfilingGroupRequest.builder().profilingGroupName(this.profilingGroupName).computePlatform(this.computePlatform).build());
            if (response != null && response.profilingGroup() != null) {
                LOG.log(Level.INFO, String.format("Profiling group with name %s was successfully created.", this.profilingGroupName));
                return Optional.of(response.profilingGroup());
            }
        }
        catch (ConflictException ce) {
            LOG.log(Level.INFO, String.format("ProfilingGroup %s already exists.", this.profilingGroupName), ce);
        }
        catch (Exception e) {
            this.errorsMetadata.recordSdk(LOG, Level.INFO, String.format("Exception while creating profiling group with name = %sand compute platform = %s.", this.profilingGroupName, this.computePlatform), e, ProfileIonKeys.SDK_ERROR_TYPE.CREATE_PROFILING_GROUP_ERRORS);
        }
        return Optional.empty();
    }

    private boolean shouldAutoCreateProfilingGroup() {
        return ComputePlatform.AWS_LAMBDA.toString().equals(this.computePlatform);
    }

    String getFleetInstanceId() {
        return this.fleetInstanceId;
    }

    String getComputePlatform() {
        return this.computePlatform;
    }

    CodeGuruProfilerClient getClient() {
        return this.client;
    }

    String getProfilingGroupName() {
        return this.profilingGroupName;
    }

    ProfileIonSerializer getSerializer() {
        return this.serializer;
    }

    ErrorsMetadata getErrorsMetadata() {
        return this.errorsMetadata;
    }
}

