/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.codeguruprofilerjavaagent.profile.metadata;

import com.amazon.ion.IonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.UUID;
import software.amazon.codeguruprofilerjavaagent.profile.IonUtils;
import software.amazon.codeguruprofilerjavaagent.profile.metadata.FleetInfo;

public class FleetInstance
implements FleetInfo {
    private final String id;
    private final String type;
    private final BigDecimal costPerHour;
    private final BigDecimal vCPUs;

    public FleetInstance(String id, String type, BigDecimal costPerHour, BigDecimal vCPUs) {
        this.id = id;
        this.type = type;
        this.costPerHour = costPerHour;
        this.vCPUs = vCPUs;
    }

    public static FleetInstance buildDefault() {
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        return new FleetInstance(UUID.randomUUID().toString(), "UNKNOWN", null, new BigDecimal(availableProcessors));
    }

    @Override
    public void write(IonWriter out) throws IOException {
        IonUtils.writeStruct(out, () -> {
            IonUtils.writeString(out, "id", this.id);
            IonUtils.writeString(out, "type", this.type);
            if (this.costPerHour != null) {
                IonUtils.writeDecimal(out, "costPerHour", this.costPerHour);
            }
            if (this.vCPUs != null) {
                IonUtils.writeDecimal(out, "vCPUs", this.vCPUs);
            }
        });
    }

    @Override
    public String getFleetInstanceId() {
        return this.id;
    }

    public String toString() {
        return "FleetInstance{id=" + this.id + ", type=" + this.type + ", costPerHour=" + this.costPerHour + ", vCPUs=" + this.vCPUs + '}';
    }
}

