/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.codeguruprofilerjavaagent.flightrecorder;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jdk.jfr.EventType;
import jdk.jfr.consumer.RecordedClass;
import jdk.jfr.consumer.RecordedEvent;
import jdk.jfr.consumer.RecordedFrame;
import jdk.jfr.consumer.RecordedMethod;
import jdk.jfr.consumer.RecordedStackTrace;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import software.amazon.codeguruprofilerjavaagent.flightrecorder.EventProcessor;
import software.amazon.codeguruprofilerjavaagent.flightrecorder.EventProcessorHelper;
import software.amazon.codeguruprofilerjavaagent.flightrecorder.FlightRecorderEventType;
import software.amazon.codeguruprofilerjavaagent.profile.CallGraphBuilder;
import software.amazon.codeguruprofilerjavaagent.profile.MemoryCounter;
import software.amazon.codeguruprofilerjavaagent.profile.ProfileBuilder;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002J\u001e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\nH\u0014J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\n2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u001c\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00180\n2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00180\nH\u0002J\u001e\u0010\u001f\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00180\nH\u0002J\u0010\u0010 \u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\u0018H\u0002J6\u0010\"\u001a\u00020\u00142\u0006\u0010#\u001a\u00020$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001a0\n2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010 \u001a\u00020\u000fH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006("}, d2={"Lsoftware/amazon/codeguruprofilerjavaagent/flightrecorder/AllocationEventProcessor;", "Lsoftware/amazon/codeguruprofilerjavaagent/flightrecorder/EventProcessor;", "maxEventsPerSecond", "", "(I)V", "logger", "Ljava/util/logging/Logger;", "getMaxEventsPerSecond", "()I", "supportedEvents", "", "Lsoftware/amazon/codeguruprofilerjavaagent/flightrecorder/FlightRecorderEventType;", "getSupportedEvents", "()Ljava/util/List;", "allocationInNewTlabScalingFactor", "", "allocationSizeBytes", "", "tlabSizeBytes", "doProcess", "", "profileBuilder", "Lsoftware/amazon/codeguruprofilerjavaagent/profile/ProfileBuilder;", "recordedEvents", "Ljdk/jfr/consumer/RecordedEvent;", "getFrames", "Ljava/lang/StackTraceElement;", "recordedStackTrace", "Ljdk/jfr/consumer/RecordedStackTrace;", "limitEventRate", "events", "processSingleEventType", "scalingFactor", "event", "updateCallGraph", "callGraphBuilder", "Lsoftware/amazon/codeguruprofilerjavaagent/profile/CallGraphBuilder;", "stackTrace", "objectType", "", "SkySailJavaAgent"})
public final class AllocationEventProcessor
extends EventProcessor {
    @NotNull
    private final List<FlightRecorderEventType> supportedEvents;
    private final Logger logger;
    private final int maxEventsPerSecond;

    @Override
    @NotNull
    public List<FlightRecorderEventType> getSupportedEvents() {
        return this.supportedEvents;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void doProcess(@NotNull ProfileBuilder profileBuilder, @NotNull List<RecordedEvent> recordedEvents) {
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        Intrinsics.checkParameterIsNotNull((Object)profileBuilder, (String)"profileBuilder");
        Intrinsics.checkParameterIsNotNull(recordedEvents, (String)"recordedEvents");
        if (recordedEvents.isEmpty()) {
            this.logger.log(Level.FINE, "The list containing recorded events is empty!");
            return;
        }
        Iterable $this$filter$iv = recordedEvents;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            RecordedEvent it = (RecordedEvent)element$iv$iv;
            boolean bl = false;
            EventType eventType = it.getEventType();
            Intrinsics.checkExpressionValueIsNotNull((Object)eventType, (String)"it.eventType");
            if (!Intrinsics.areEqual((Object)eventType.getName(), (Object)FlightRecorderEventType.AllocationInNewTlab.getEventName())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List allocationsInsideNewTlab = (List)destination$iv$iv;
        Iterable $this$filter$iv2 = recordedEvents;
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            RecordedEvent it = (RecordedEvent)element$iv$iv;
            boolean bl = false;
            EventType eventType = it.getEventType();
            Intrinsics.checkExpressionValueIsNotNull((Object)eventType, (String)"it.eventType");
            if (!Intrinsics.areEqual((Object)eventType.getName(), (Object)FlightRecorderEventType.AllocationOutsideTlab.getEventName())) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List allocationsOutsideTlab = (List)destination$iv$iv2;
        this.processSingleEventType(profileBuilder, allocationsInsideNewTlab);
        this.processSingleEventType(profileBuilder, allocationsOutsideTlab);
    }

    private final void processSingleEventType(ProfileBuilder profileBuilder, List<RecordedEvent> events) {
        List<RecordedEvent> selectedEvents = this.limitEventRate(events);
        double rateLimitingScalingFactor = (double)events.size() / (double)selectedEvents.size();
        Iterable $this$forEach$iv = selectedEvents;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List<StackTraceElement> list;
            long allocationSizeBytes;
            String objectType;
            RecordedEvent event;
            block4: {
                block3: {
                    event = (RecordedEvent)element$iv;
                    boolean bl = false;
                    RecordedClass recordedClass = event.getClass("objectClass");
                    Intrinsics.checkExpressionValueIsNotNull((Object)recordedClass, (String)"event.getClass(\"objectClass\")");
                    String string = recordedClass.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"event.getClass(\"objectClass\").name");
                    objectType = EventProcessorHelper.INSTANCE.translate(string);
                    allocationSizeBytes = event.getLong("allocationSize");
                    list = event.getStackTrace();
                    if (list == null) break block3;
                    RecordedStackTrace recordedStackTrace = list;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    RecordedStackTrace it = recordedStackTrace;
                    boolean bl4 = false;
                    list = this.getFrames(it);
                    if (list != null) break block4;
                }
                list = CollectionsKt.emptyList();
            }
            List<StackTraceElement> stackTrace = list;
            this.updateCallGraph(profileBuilder.getCallGraphBuilder(), stackTrace, objectType, allocationSizeBytes, this.scalingFactor(event) * rateLimitingScalingFactor);
        }
    }

    private final List<RecordedEvent> limitEventRate(List<RecordedEvent> events) {
        Object v2;
        Object v0;
        if (events.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$minBy$iv = events;
        boolean $i$f$minBy = false;
        Iterator iterator$iv = $this$minBy$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                RecordedEvent it = (RecordedEvent)minElem$iv;
                boolean bl = false;
                Comparable minValue$iv = it.getStartTime();
                do {
                    Object e$iv = iterator$iv.next();
                    RecordedEvent it2 = (RecordedEvent)e$iv;
                    $i$a$-minBy-AllocationEventProcessor$limitEventRate$firstEventStartTime$1 = false;
                    Comparable v$iv = it2.getStartTime();
                    if (minValue$iv.compareTo(v$iv) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        RecordedEvent recordedEvent = v0;
        Instant firstEventStartTime = recordedEvent != null ? recordedEvent.getStartTime() : null;
        Iterable $this$maxBy$iv = events;
        boolean $i$f$maxBy = false;
        Iterator iterator$iv2 = $this$maxBy$iv.iterator();
        if (!iterator$iv2.hasNext()) {
            v2 = null;
        } else {
            Object maxElem$iv = iterator$iv2.next();
            if (!iterator$iv2.hasNext()) {
                v2 = maxElem$iv;
            } else {
                RecordedEvent it = (RecordedEvent)maxElem$iv;
                boolean bl = false;
                Comparable maxValue$iv = it.getEndTime();
                do {
                    Object e$iv = iterator$iv2.next();
                    RecordedEvent it3 = (RecordedEvent)e$iv;
                    $i$a$-maxBy-AllocationEventProcessor$limitEventRate$lastEventEndTime$1 = false;
                    Comparable v$iv = it3.getEndTime();
                    if (maxValue$iv.compareTo(v$iv) >= 0) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv2.hasNext());
                v2 = maxElem$iv;
            }
        }
        RecordedEvent recordedEvent2 = v2;
        Instant lastEventEndTime = recordedEvent2 != null ? recordedEvent2.getEndTime() : null;
        Duration captureDuration = Duration.between(firstEventStartTime, lastEventEndTime);
        long l = 1L;
        Duration duration = captureDuration;
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"captureDuration");
        long l2 = duration.getSeconds();
        boolean bl = false;
        long maxNumEvents = Math.max(l, l2) * (long)this.maxEventsPerSecond;
        return CollectionsKt.take((Iterable)CollectionsKt.shuffled((Iterable)events), (int)((int)maxNumEvents));
    }

    /*
     * WARNING - void declaration
     */
    private final void updateCallGraph(CallGraphBuilder callGraphBuilder, List<StackTraceElement> stackTrace, String objectType, long allocationSizeBytes, double scalingFactor) {
        void $this$toTypedArray$iv;
        if (stackTrace.isEmpty()) {
            return;
        }
        String noMethodNameAvailable = "";
        String noFileNameAvailable = "";
        int noLineNumAvailable = -1;
        StackTraceElement objectTypeFrame = new StackTraceElement(objectType, noMethodNameAvailable, noFileNameAvailable, noLineNumAvailable);
        SpreadBuilder spreadBuilder = new SpreadBuilder(2);
        spreadBuilder.add((Object)objectTypeFrame);
        Collection collection = stackTrace;
        SpreadBuilder spreadBuilder2 = spreadBuilder;
        SpreadBuilder spreadBuilder3 = spreadBuilder;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        StackTraceElement[] stackTraceElementArray = thisCollection$iv.toArray(new StackTraceElement[0]);
        if (stackTraceElementArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        StackTraceElement[] stackTraceElementArray2 = stackTraceElementArray;
        SpreadBuilder spreadBuilder4 = spreadBuilder3;
        spreadBuilder2.addSpread((Object)stackTraceElementArray2);
        StackTraceElement[] newStack = (StackTraceElement[])spreadBuilder4.toArray((Object[])new StackTraceElement[spreadBuilder4.size()]);
        callGraphBuilder.capture(MemoryCounter.ALLOCATED_BYTES, MathKt.roundToInt((double)((double)allocationSizeBytes * scalingFactor)), Arrays.copyOf(newStack, newStack.length));
        callGraphBuilder.capture(MemoryCounter.ALLOCATION_COUNT, MathKt.roundToInt((double)(1.0 * scalingFactor)), Arrays.copyOf(newStack, newStack.length));
    }

    /*
     * WARNING - void declaration
     */
    private final List<StackTraceElement> getFrames(RecordedStackTrace recordedStackTrace) {
        void $this$mapTo$iv$iv;
        String noFileNameAvailable = "";
        int noLineNumAvailable = -1;
        List<RecordedFrame> list = recordedStackTrace.getFrames();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"recordedStackTrace.frames");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Object object;
            void it;
            RecordedFrame recordedFrame = (RecordedFrame)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void v1 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
            Object object2 = v1.getMethod();
            if (object2 == null || (object2 = ((RecordedMethod)object2).getType()) == null || (object2 = ((RecordedClass)object2).getName()) == null) {
                object2 = "Unknown";
            }
            if ((object = it.getMethod()) == null || (object = ((RecordedMethod)object).getName()) == null) {
                object = "Unknown";
            }
            StackTraceElement stackTraceElement = new StackTraceElement((String)object2, (String)object, noFileNameAvailable, noLineNumAvailable);
            collection.add(stackTraceElement);
        }
        return (List)destination$iv$iv;
    }

    private final double scalingFactor(RecordedEvent event) {
        double d;
        EventType eventType = event.getEventType();
        Intrinsics.checkExpressionValueIsNotNull((Object)eventType, (String)"event.eventType");
        String string = eventType.getName();
        if (Intrinsics.areEqual((Object)string, (Object)FlightRecorderEventType.AllocationInNewTlab.getEventName())) {
            d = this.allocationInNewTlabScalingFactor(event.getLong("allocationSize"), event.getLong("tlabSize"));
        } else if (Intrinsics.areEqual((Object)string, (Object)FlightRecorderEventType.AllocationOutsideTlab.getEventName())) {
            d = 1.0;
        } else {
            StringBuilder stringBuilder = new StringBuilder().append("Unsupported event type: ");
            EventType eventType2 = event.getEventType();
            Intrinsics.checkExpressionValueIsNotNull((Object)eventType2, (String)"event.eventType");
            throw (Throwable)new UnsupportedOperationException(stringBuilder.append(eventType2.getName()).append('.').toString());
        }
        return d;
    }

    private final double allocationInNewTlabScalingFactor(long allocationSizeBytes, long tlabSizeBytes) {
        return (double)tlabSizeBytes / (double)allocationSizeBytes;
    }

    public final int getMaxEventsPerSecond() {
        return this.maxEventsPerSecond;
    }

    public AllocationEventProcessor(int maxEventsPerSecond) {
        this.maxEventsPerSecond = maxEventsPerSecond;
        this.supportedEvents = CollectionsKt.listOf((Object[])new FlightRecorderEventType[]{FlightRecorderEventType.AllocationInNewTlab, FlightRecorderEventType.AllocationOutsideTlab});
        Logger logger = Logger.getLogger("javaClass");
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getLogger(Allocat\u2026rocessor::javaClass.name)");
        this.logger = logger;
    }

    public /* synthetic */ AllocationEventProcessor(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 1;
        }
        this(n);
    }

    public AllocationEventProcessor() {
        this(0, 1, null);
    }
}

