/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.codeguruprofilerjavaagent.profile.metadata;

import com.amazon.ion.IonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.Duration;
import software.amazon.codeguruprofilerjavaagent.profile.IonUtils;

public class SamplingMetadata {
    private BigDecimal sampleWeight;
    private Duration samplingDuration;
    private AgentOverhead agentOverhead;
    private Duration cpuTime;
    private double avgNumThreads;

    public SamplingMetadata(BigDecimal sampleWeight, Duration samplingDuration, AgentOverhead agentOverhead, Duration cpuTime, double avgNumThreads) {
        this.sampleWeight = sampleWeight;
        this.samplingDuration = samplingDuration;
        this.agentOverhead = agentOverhead;
        this.cpuTime = cpuTime;
        this.avgNumThreads = avgNumThreads;
    }

    public BigDecimal getSampleWeight() {
        return this.sampleWeight;
    }

    public Duration getSamplingDuration() {
        return this.samplingDuration;
    }

    public AgentOverhead getAgentOverhead() {
        return this.agentOverhead;
    }

    public Duration getCpuTime() {
        return this.cpuTime;
    }

    public double getAvgNumThreads() {
        return this.avgNumThreads;
    }

    public static class AgentOverhead {
        private final Duration time;
        private final long memoryInMB;

        public AgentOverhead(Duration time, long memoryInMB) {
            this.time = time;
            this.memoryInMB = memoryInMB;
        }

        void write(IonWriter out, String fieldName) throws IOException {
            IonUtils.writeStruct(out, fieldName, () -> {
                IonUtils.writeInt(out, "timeInMs", this.time.toMillis());
                IonUtils.writeInt(out, "memoryInMB", this.memoryInMB);
            });
        }

        public Duration getTime() {
            return this.time;
        }

        public long getMemoryInMB() {
            return this.memoryInMB;
        }
    }
}

