/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.codeguruprofilerjavaagent.flightrecorder;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jdk.jfr.Recording;
import jdk.jfr.RecordingState;
import jdk.jfr.consumer.RecordedEvent;
import jdk.jfr.consumer.RecordingFile;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.codeguruprofilerjavaagent.flightrecorder.FlightRecorderEventType;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B]\u00128\b\u0002\u0010\u0002\u001a2\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\b\u0012\u0004\u0012\u00020\t0\u0003\u0012\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\fH\u0002J\b\u0010\u001e\u001a\u00020\tH\u0002J\b\u0010\u001f\u001a\u00020\u001cH\u0002J\u0006\u0010 \u001a\u00020!J\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u000eJ\u0006\u0010$\u001a\u00020\u001cJ\u0010\u0010%\u001a\u00020\u001c2\b\b\u0002\u0010&\u001a\u00020!R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0013\u001a\u0004\u0018\u00010\u00122\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012@BX\u0086\u000e\u00a2\u0006\n\n\u0002\u0010\u0016\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R>\u0010\u0002\u001a2\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\b\u0012\u0004\u0012\u00020\t0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lsoftware/amazon/codeguruprofilerjavaagent/flightrecorder/RecordingHandler;", "", "temporaryFileFactory", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "prefix", "suffix", "Ljava/io/File;", "recordingFactory", "Lkotlin/Function0;", "Ljdk/jfr/Recording;", "eventTypes", "", "Lsoftware/amazon/codeguruprofilerjavaagent/flightrecorder/FlightRecorderEventType;", "(Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function0;Ljava/util/List;)V", "<set-?>", "", "latestRecordingFileSizeBytes", "getLatestRecordingFileSizeBytes", "()Ljava/lang/Long;", "Ljava/lang/Long;", "logger", "Ljava/util/logging/Logger;", "recording", "recordingFile", "closeRecording", "", "createRecording", "createTempFile", "emptyRecordingFile", "isRecording", "", "processRecordedEvents", "Ljdk/jfr/consumer/RecordedEvent;", "startRecording", "stopRecording", "dropData", "SkySailJavaAgent"})
public final class RecordingHandler {
    private final Logger logger;
    private final File recordingFile;
    private Recording recording;
    @Nullable
    private Long latestRecordingFileSizeBytes;
    private final Function2<String, String, File> temporaryFileFactory;
    private final Function0<Recording> recordingFactory;
    private final List<FlightRecorderEventType> eventTypes;

    @Nullable
    public final Long getLatestRecordingFileSizeBytes() {
        return this.latestRecordingFileSizeBytes;
    }

    public final void startRecording() {
        RecordingState currentState = this.recording.getState();
        if (currentState == RecordingState.CLOSED || currentState == RecordingState.NEW) {
            this.recording = this.createRecording();
            this.recording.start();
            this.logger.log(Level.FINE, "Started the JFR Recording!");
        }
    }

    public final void stopRecording(boolean dropData) {
        if (!this.isRecording()) {
            return;
        }
        if (dropData) {
            this.closeRecording();
            return;
        }
        this.recording.stop();
        this.logger.log(Level.FINE, "Stopped the JFR Recording!");
    }

    public static /* synthetic */ void stopRecording$default(RecordingHandler recordingHandler, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        recordingHandler.stopRecording(bl);
    }

    public final boolean isRecording() {
        return this.recording.getState() == RecordingState.RUNNING;
    }

    @NotNull
    public final List<RecordedEvent> processRecordedEvents() {
        List<RecordedEvent> recordedEvents = CollectionsKt.emptyList();
        if (this.recording.getState() != RecordingState.STOPPED) {
            return recordedEvents;
        }
        try {
            Path path = this.recordingFile.toPath();
            this.recording.dump(path);
            List<RecordedEvent> list = RecordingFile.readAllEvents(path);
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"RecordingFile.readAllEvents(path)");
            recordedEvents = list;
            this.latestRecordingFileSizeBytes = Files.size(path);
            this.emptyRecordingFile();
        }
        catch (IOException e) {
            this.logger.log(Level.FINE, "An IOException occurred while retrieving recorded events!", e);
        }
        this.closeRecording();
        return recordedEvents;
    }

    private final void closeRecording() {
        if (this.recording.getState() == RecordingState.CLOSED) {
            return;
        }
        this.recording.close();
        this.logger.log(Level.FINE, "Closed the JFR Recording!");
    }

    private final File createTempFile() throws IOException {
        File newFile = (File)this.temporaryFileFactory.invoke((Object)"jfr-recording", (Object)".jfr");
        newFile.deleteOnExit();
        return newFile;
    }

    private final void emptyRecordingFile() throws IOException {
        new FileWriter(this.recordingFile, false).close();
    }

    private final Recording createRecording() {
        Recording newRecording = (Recording)this.recordingFactory.invoke();
        newRecording.setToDisk(true);
        newRecording.setMaxSize(50000000L);
        Iterable $this$forEach$iv = this.eventTypes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FlightRecorderEventType it = (FlightRecorderEventType)((Object)element$iv);
            boolean bl = false;
            newRecording.enable(it.getEventName());
        }
        this.logger.log(Level.FINE, "Created a new JFR Recording!");
        return newRecording;
    }

    public RecordingHandler(@NotNull Function2<? super String, ? super String, ? extends File> temporaryFileFactory, @NotNull Function0<Recording> recordingFactory, @NotNull List<? extends FlightRecorderEventType> eventTypes) {
        Intrinsics.checkParameterIsNotNull(temporaryFileFactory, (String)"temporaryFileFactory");
        Intrinsics.checkParameterIsNotNull(recordingFactory, (String)"recordingFactory");
        Intrinsics.checkParameterIsNotNull(eventTypes, (String)"eventTypes");
        this.temporaryFileFactory = temporaryFileFactory;
        this.recordingFactory = recordingFactory;
        this.eventTypes = eventTypes;
        Logger logger = Logger.getLogger("javaClass");
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getLogger(RecordingHandler::javaClass.name)");
        this.logger = logger;
        this.recordingFile = this.createTempFile();
        this.recording = this.createRecording();
    }

    public /* synthetic */ RecordingHandler(Function2 function2, Function0 function0, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            function2 = 1.INSTANCE;
        }
        if ((n & 2) != 0) {
            function0 = 2.INSTANCE;
        }
        this((Function2<? super String, ? super String, ? extends File>)function2, (Function0<Recording>)function0, list);
    }
}

