/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.codeguruprofilerjavaagent.flightrecorder;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import jdk.jfr.EventType;
import jdk.jfr.consumer.RecordedClass;
import jdk.jfr.consumer.RecordedEvent;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.codeguruprofilerjavaagent.flightrecorder.EventProcessor;
import software.amazon.codeguruprofilerjavaagent.flightrecorder.EventProcessorHelper;
import software.amazon.codeguruprofilerjavaagent.flightrecorder.FlightRecorderEventType;
import software.amazon.codeguruprofilerjavaagent.profile.ClassSummary;
import software.amazon.codeguruprofilerjavaagent.profile.ProfileBuilder;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0010B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0006H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"Lsoftware/amazon/codeguruprofilerjavaagent/flightrecorder/ObjectCountEventProcessor;", "Lsoftware/amazon/codeguruprofilerjavaagent/flightrecorder/EventProcessor;", "runtimeMxBean", "Ljava/lang/management/RuntimeMXBean;", "(Ljava/lang/management/RuntimeMXBean;)V", "supportedEvents", "", "Lsoftware/amazon/codeguruprofilerjavaagent/flightrecorder/FlightRecorderEventType;", "getSupportedEvents", "()Ljava/util/List;", "doProcess", "", "profileBuilder", "Lsoftware/amazon/codeguruprofilerjavaagent/profile/ProfileBuilder;", "recordedEvents", "Ljdk/jfr/consumer/RecordedEvent;", "ObjectCountEvent", "SkySailJavaAgent"})
public final class ObjectCountEventProcessor
extends EventProcessor {
    @NotNull
    private final List<FlightRecorderEventType> supportedEvents;
    private final RuntimeMXBean runtimeMxBean;

    @Override
    @NotNull
    public List<FlightRecorderEventType> getSupportedEvents() {
        return this.supportedEvents;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void doProcess(@NotNull ProfileBuilder profileBuilder, @NotNull List<RecordedEvent> recordedEvents) {
        void $this$groupByTo$iv$iv;
        Object item$iv$iv3;
        void $this$mapTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        ObjectCountEvent objectCountEvent;
        Collection collection;
        void $this$mapTo$iv$iv2;
        RecordedEvent it;
        Iterable $this$filterTo$iv$iv2;
        Intrinsics.checkParameterIsNotNull((Object)profileBuilder, (String)"profileBuilder");
        Intrinsics.checkParameterIsNotNull(recordedEvents, (String)"recordedEvents");
        Iterable $this$filter$iv = recordedEvents;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            it = (RecordedEvent)element$iv$iv;
            boolean bl = false;
            EventType eventType = it.getEventType();
            Intrinsics.checkExpressionValueIsNotNull((Object)eventType, (String)"it.eventType");
            if (!Intrinsics.areEqual((Object)eventType.getName(), (Object)FlightRecorderEventType.ObjectCountAfterGC.getEventName())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv2 = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
            it = (RecordedEvent)item$iv$iv2;
            collection = destination$iv$iv;
            boolean bl = false;
            objectCountEvent = new ObjectCountEvent(it);
            collection.add(objectCountEvent);
        }
        List objectCountEvents = (List)destination$iv$iv;
        Iterable $this$filter$iv2 = recordedEvents;
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            RecordedEvent it2 = (RecordedEvent)element$iv$iv;
            boolean bl = false;
            EventType eventType = it2.getEventType();
            Intrinsics.checkExpressionValueIsNotNull((Object)eventType, (String)"it.eventType");
            if (!(Intrinsics.areEqual((Object)eventType.getName(), (Object)FlightRecorderEventType.GCHeapSummary.getEventName()) && Intrinsics.areEqual((Object)it2.getString("when"), (Object)"After GC"))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        Iterable $this$map$iv2 = (List)destination$iv$iv2;
        boolean $i$f$map2 = false;
        $this$filterTo$iv$iv = $this$map$iv2;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv3 : $this$mapTo$iv$iv) {
            RecordedEvent it2 = (RecordedEvent)item$iv$iv3;
            collection = destination$iv$iv2;
            boolean bl = false;
            objectCountEvent = TuplesKt.to((Object)it2.getInt("gcId"), (Object)it2.getLong("heapUsed"));
            collection.add(objectCountEvent);
        }
        Map afterGCHeapUsed = MapsKt.toMap((Iterable)((List)destination$iv$iv2));
        long maxHeapAvailableBytes = Runtime.getRuntime().maxMemory();
        long uptimeMillis = this.runtimeMxBean.getUptime();
        Iterable $this$groupBy$iv = objectCountEvents;
        boolean $i$f$groupBy = false;
        item$iv$iv3 = $this$groupBy$iv;
        Map destination$iv$iv3 = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            ObjectCountEvent it3 = (ObjectCountEvent)element$iv$iv;
            boolean bl = false;
            Integer key$iv$iv = it3.getGcId();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv3;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                ArrayList answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        destination$iv$iv3.forEach((BiConsumer)new BiConsumer<Integer, List<? extends ObjectCountEvent>>(afterGCHeapUsed, profileBuilder, uptimeMillis, maxHeapAvailableBytes){
            final /* synthetic */ Map $afterGCHeapUsed;
            final /* synthetic */ ProfileBuilder $profileBuilder;
            final /* synthetic */ long $uptimeMillis;
            final /* synthetic */ long $maxHeapAvailableBytes;

            /*
             * WARNING - void declaration
             */
            public final void accept(@NotNull Integer gcId, @NotNull List<ObjectCountEvent> events) {
                void $this$mapTo$iv$iv;
                ObjectCountEvent eventWithMinStartTime;
                Object minValue$iv;
                Object v0;
                Intrinsics.checkParameterIsNotNull((Object)gcId, (String)"gcId");
                Intrinsics.checkParameterIsNotNull(events, (String)"events");
                Long heapUsedBytes = (Long)this.$afterGCHeapUsed.get(gcId);
                Iterable $this$minBy$iv = events;
                boolean $i$f$minBy = false;
                Iterator<T> iterator$iv = $this$minBy$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    v0 = null;
                } else {
                    T minElem$iv = iterator$iv.next();
                    if (!iterator$iv.hasNext()) {
                        v0 = minElem$iv;
                    } else {
                        ObjectCountEvent it = (ObjectCountEvent)minElem$iv;
                        boolean bl = false;
                        minValue$iv = it.getEventStartTime();
                        do {
                            T e$iv = iterator$iv.next();
                            ObjectCountEvent it2 = (ObjectCountEvent)e$iv;
                            $i$a$-minBy-ObjectCountEventProcessor$doProcess$2$eventWithMinStartTime$1 = false;
                            Comparable v$iv = it2.getEventStartTime();
                            if (minValue$iv.compareTo(v$iv) <= 0) continue;
                            minElem$iv = e$iv;
                            minValue$iv = v$iv;
                        } while (iterator$iv.hasNext());
                        v0 = minElem$iv;
                    }
                }
                ObjectCountEvent objectCountEvent = eventWithMinStartTime = (ObjectCountEvent)v0;
                if (objectCountEvent == null) {
                    Intrinsics.throwNpe();
                }
                Instant captureTimestamp = objectCountEvent.getEventStartTime();
                Iterable $this$map$iv = events;
                boolean $i$f$map = false;
                minValue$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    ObjectCountEvent objectCountEvent2 = (ObjectCountEvent)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    ClassSummary classSummary = new ClassSummary(it.getObjectType(), it.getObjectCount(), it.getTotalSizeBytes());
                    collection.add(classSummary);
                }
                List classSummaries = (List)destination$iv$iv;
                this.$profileBuilder.getHeapSummariesBuilder().capture(captureTimestamp, this.$uptimeMillis, this.$maxHeapAvailableBytes, heapUsedBytes, classSummaries);
            }
            {
                this.$afterGCHeapUsed = map;
                this.$profileBuilder = profileBuilder;
                this.$uptimeMillis = l;
                this.$maxHeapAvailableBytes = l2;
            }
        });
    }

    public ObjectCountEventProcessor(@NotNull RuntimeMXBean runtimeMxBean) {
        Intrinsics.checkParameterIsNotNull((Object)runtimeMxBean, (String)"runtimeMxBean");
        this.runtimeMxBean = runtimeMxBean;
        this.supportedEvents = CollectionsKt.listOf((Object[])new FlightRecorderEventType[]{FlightRecorderEventType.ObjectCountAfterGC, FlightRecorderEventType.GCHeapSummary});
    }

    public /* synthetic */ ObjectCountEventProcessor(RuntimeMXBean runtimeMXBean, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            RuntimeMXBean runtimeMXBean2 = ManagementFactory.getRuntimeMXBean();
            Intrinsics.checkExpressionValueIsNotNull((Object)runtimeMXBean2, (String)"ManagementFactory.getRuntimeMXBean()");
            runtimeMXBean = runtimeMXBean2;
        }
        this(runtimeMXBean);
    }

    public ObjectCountEventProcessor() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\b\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B-\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\t\u0010\u0018\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\bH\u00c6\u0003J\t\u0010\u001a\u001a\u00020\nH\u00c6\u0003J\t\u0010\u001b\u001a\u00020\bH\u00c6\u0003J\t\u0010\u001c\u001a\u00020\rH\u00c6\u0003J;\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\b2\b\b\u0002\u0010\f\u001a\u00020\rH\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010!\u001a\u00020\rH\u00d6\u0001J\t\u0010\"\u001a\u00020\nH\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u000b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0014\u00a8\u0006#"}, d2={"Lsoftware/amazon/codeguruprofilerjavaagent/flightrecorder/ObjectCountEventProcessor$ObjectCountEvent;", "", "recordedEvent", "Ljdk/jfr/consumer/RecordedEvent;", "(Ljdk/jfr/consumer/RecordedEvent;)V", "eventStartTime", "Ljava/time/Instant;", "objectCount", "", "objectType", "", "totalSizeBytes", "gcId", "", "(Ljava/time/Instant;JLjava/lang/String;JI)V", "getEventStartTime", "()Ljava/time/Instant;", "getGcId", "()I", "getObjectCount", "()J", "getObjectType", "()Ljava/lang/String;", "getTotalSizeBytes", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "toString", "SkySailJavaAgent"})
    private static final class ObjectCountEvent {
        @NotNull
        private final Instant eventStartTime;
        private final long objectCount;
        @NotNull
        private final String objectType;
        private final long totalSizeBytes;
        private final int gcId;

        @NotNull
        public final Instant getEventStartTime() {
            return this.eventStartTime;
        }

        public final long getObjectCount() {
            return this.objectCount;
        }

        @NotNull
        public final String getObjectType() {
            return this.objectType;
        }

        public final long getTotalSizeBytes() {
            return this.totalSizeBytes;
        }

        public final int getGcId() {
            return this.gcId;
        }

        public ObjectCountEvent(@NotNull Instant eventStartTime, long objectCount, @NotNull String objectType, long totalSizeBytes, int gcId) {
            Intrinsics.checkParameterIsNotNull((Object)eventStartTime, (String)"eventStartTime");
            Intrinsics.checkParameterIsNotNull((Object)objectType, (String)"objectType");
            this.eventStartTime = eventStartTime;
            this.objectCount = objectCount;
            this.objectType = objectType;
            this.totalSizeBytes = totalSizeBytes;
            this.gcId = gcId;
        }

        public ObjectCountEvent(@NotNull RecordedEvent recordedEvent) {
            Intrinsics.checkParameterIsNotNull((Object)recordedEvent, (String)"recordedEvent");
            Instant instant = recordedEvent.getStartTime();
            Intrinsics.checkExpressionValueIsNotNull((Object)instant, (String)"recordedEvent.startTime");
            long l = recordedEvent.getLong("count");
            RecordedClass recordedClass = recordedEvent.getClass("objectClass");
            Intrinsics.checkExpressionValueIsNotNull((Object)recordedClass, (String)"recordedEvent.getClass(\"objectClass\")");
            String string = recordedClass.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"recordedEvent.getClass(\"objectClass\").name");
            this(instant, l, EventProcessorHelper.INSTANCE.translate(string), recordedEvent.getLong("totalSize"), recordedEvent.getInt("gcId"));
        }

        @NotNull
        public final Instant component1() {
            return this.eventStartTime;
        }

        public final long component2() {
            return this.objectCount;
        }

        @NotNull
        public final String component3() {
            return this.objectType;
        }

        public final long component4() {
            return this.totalSizeBytes;
        }

        public final int component5() {
            return this.gcId;
        }

        @NotNull
        public final ObjectCountEvent copy(@NotNull Instant eventStartTime, long objectCount, @NotNull String objectType, long totalSizeBytes, int gcId) {
            Intrinsics.checkParameterIsNotNull((Object)eventStartTime, (String)"eventStartTime");
            Intrinsics.checkParameterIsNotNull((Object)objectType, (String)"objectType");
            return new ObjectCountEvent(eventStartTime, objectCount, objectType, totalSizeBytes, gcId);
        }

        public static /* synthetic */ ObjectCountEvent copy$default(ObjectCountEvent objectCountEvent, Instant instant, long l, String string, long l2, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                instant = objectCountEvent.eventStartTime;
            }
            if ((n2 & 2) != 0) {
                l = objectCountEvent.objectCount;
            }
            if ((n2 & 4) != 0) {
                string = objectCountEvent.objectType;
            }
            if ((n2 & 8) != 0) {
                l2 = objectCountEvent.totalSizeBytes;
            }
            if ((n2 & 0x10) != 0) {
                n = objectCountEvent.gcId;
            }
            return objectCountEvent.copy(instant, l, string, l2, n);
        }

        @NotNull
        public String toString() {
            return "ObjectCountEvent(eventStartTime=" + this.eventStartTime + ", objectCount=" + this.objectCount + ", objectType=" + this.objectType + ", totalSizeBytes=" + this.totalSizeBytes + ", gcId=" + this.gcId + ")";
        }

        public int hashCode() {
            Instant instant = this.eventStartTime;
            String string = this.objectType;
            return ((((instant != null ? ((Object)instant).hashCode() : 0) * 31 + Long.hashCode(this.objectCount)) * 31 + (string != null ? string.hashCode() : 0)) * 31 + Long.hashCode(this.totalSizeBytes)) * 31 + Integer.hashCode(this.gcId);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ObjectCountEvent)) break block3;
                    ObjectCountEvent objectCountEvent = (ObjectCountEvent)object;
                    if (!Intrinsics.areEqual((Object)this.eventStartTime, (Object)objectCountEvent.eventStartTime) || this.objectCount != objectCountEvent.objectCount || !Intrinsics.areEqual((Object)this.objectType, (Object)objectCountEvent.objectType) || this.totalSizeBytes != objectCountEvent.totalSizeBytes || this.gcId != objectCountEvent.gcId) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

