/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cloudwatchlogs.emf.model;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import software.amazon.cloudwatchlogs.emf.exception.DimensionSetExceededException;
import software.amazon.cloudwatchlogs.emf.exception.InvalidDimensionException;
import software.amazon.cloudwatchlogs.emf.util.Validator;

public class DimensionSet {
    private final Map<String, String> dimensionRecords = new LinkedHashMap<String, String>();

    public static DimensionSet of(String d1, String v1) throws InvalidDimensionException {
        return DimensionSet.fromEntries(DimensionSet.entryOf(d1, v1));
    }

    public static DimensionSet of(String d1, String v1, String d2, String v2) throws InvalidDimensionException {
        return DimensionSet.fromEntries(DimensionSet.entryOf(d1, v1), DimensionSet.entryOf(d2, v2));
    }

    public static DimensionSet of(String d1, String v1, String d2, String v2, String d3, String v3) throws InvalidDimensionException {
        return DimensionSet.fromEntries(DimensionSet.entryOf(d1, v1), DimensionSet.entryOf(d2, v2), DimensionSet.entryOf(d3, v3));
    }

    public static DimensionSet of(String d1, String v1, String d2, String v2, String d3, String v3, String d4, String v4) throws InvalidDimensionException {
        return DimensionSet.fromEntries(DimensionSet.entryOf(d1, v1), DimensionSet.entryOf(d2, v2), DimensionSet.entryOf(d3, v3), DimensionSet.entryOf(d4, v4));
    }

    public static DimensionSet of(String d1, String v1, String d2, String v2, String d3, String v3, String d4, String v4, String d5, String v5) throws InvalidDimensionException {
        return DimensionSet.fromEntries(DimensionSet.entryOf(d1, v1), DimensionSet.entryOf(d2, v2), DimensionSet.entryOf(d3, v3), DimensionSet.entryOf(d4, v4), DimensionSet.entryOf(d5, v5));
    }

    private static DimensionSet fromEntries(DimensionEntry ... entries) throws InvalidDimensionException, DimensionSetExceededException {
        DimensionSet ds = new DimensionSet();
        for (DimensionEntry entry : entries) {
            ds.addDimension(entry.key, entry.value);
        }
        return ds;
    }

    private static DimensionEntry entryOf(String key, String value) {
        return new DimensionEntry(key, value);
    }

    public void addDimension(String dimension, String value) throws InvalidDimensionException, DimensionSetExceededException {
        Validator.validateDimensionSet(dimension, value);
        if (this.getDimensionKeys().size() >= 30) {
            throw new DimensionSetExceededException();
        }
        this.getDimensionRecords().put(dimension, value);
    }

    public DimensionSet add(DimensionSet other) throws DimensionSetExceededException {
        DimensionSet mergedDimensionSet = new DimensionSet();
        int mergedDimensionSetSize = this.getDimensionKeys().size() + other.dimensionRecords.keySet().size();
        if (mergedDimensionSetSize > 30) {
            throw new DimensionSetExceededException();
        }
        mergedDimensionSet.dimensionRecords.putAll(this.dimensionRecords);
        mergedDimensionSet.dimensionRecords.putAll(other.dimensionRecords);
        return mergedDimensionSet;
    }

    public Set<String> getDimensionKeys() {
        return this.dimensionRecords.keySet();
    }

    public String getDimensionValue(String key) {
        return this.dimensionRecords.get(key);
    }

    Map<String, String> getDimensionRecords() {
        return this.dimensionRecords;
    }

    static class DimensionEntry {
        private String key;
        private String value;

        public DimensionEntry(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }
    }
}

