/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cloudwatchlogs.emf.config;

import software.amazon.cloudwatchlogs.emf.config.Configuration;
import software.amazon.cloudwatchlogs.emf.config.SystemWrapper;
import software.amazon.cloudwatchlogs.emf.environment.Environments;
import software.amazon.cloudwatchlogs.emf.util.StringUtils;

public class EnvironmentConfigurationProvider {
    private static Configuration config;

    protected EnvironmentConfigurationProvider() {
    }

    public static Configuration getConfig() {
        if (config == null) {
            config = EnvironmentConfigurationProvider.createConfig();
        }
        return config;
    }

    static Configuration createConfig() {
        return new Configuration(EnvironmentConfigurationProvider.getEnvVar("SERVICE_NAME"), EnvironmentConfigurationProvider.getEnvVar("SERVICE_TYPE"), EnvironmentConfigurationProvider.getEnvVar("LOG_GROUP_NAME"), EnvironmentConfigurationProvider.getEnvVar("LOG_STREAM_NAME"), EnvironmentConfigurationProvider.getEnvVar("AGENT_ENDPOINT"), EnvironmentConfigurationProvider.getEnvironmentOverride(), EnvironmentConfigurationProvider.getIntOrDefault("ASYNC_BUFFER_SIZE", 100), Boolean.parseBoolean(EnvironmentConfigurationProvider.getEnvVar("WRITE_TO_STDOUT")));
    }

    private static Environments getEnvironmentOverride() {
        String environmentName = EnvironmentConfigurationProvider.getEnvVar("ENVIRONMENT");
        if (StringUtils.isNullOrEmpty(environmentName)) {
            return Environments.Unknown;
        }
        try {
            return Environments.valueOf(environmentName);
        }
        catch (Exception e) {
            return Environments.Unknown;
        }
    }

    private static int getIntOrDefault(String key, int defaultValue) {
        String value = EnvironmentConfigurationProvider.getEnvVar(key);
        if (StringUtils.isNullOrEmpty(value)) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private static String getEnvVar(String key) {
        String name = String.join((CharSequence)"", "AWS_EMF", "_", key);
        return EnvironmentConfigurationProvider.getEnv(name);
    }

    private static String getEnv(String name) {
        return SystemWrapper.getenv(name);
    }
}

