/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cloudformation.resource;

import java.net.URI;
import java.net.URISyntaxException;
import org.everit.json.schema.Schema;
import org.everit.json.schema.loader.SchemaClient;
import org.everit.json.schema.loader.SchemaLoader;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import software.amazon.cloudformation.resource.SchemaValidator;
import software.amazon.cloudformation.resource.exceptions.ValidationException;

class BaseValidator
implements SchemaValidator {
    protected static final String ID_KEY = "$id";
    protected static final String SOURCE_URL = "sourceUrl";
    protected static final String TYPE_NAME = "typeName";
    protected static final URI JSON_SCHEMA_URI_HTTP = BaseValidator.newURI("http://json-schema.org/draft-07/schema");
    protected static final String JSON_SCHEMA_PATH = "/schema/schema";
    protected static final String BASE_DEFINITION_SCHEMA_PATH = "/schema/base.definition.schema.v1.json";
    protected final JSONObject definitionSchemaJsonObject;
    private final JSONObject jsonSchemaObject = BaseValidator.loadResourceAsJSON("/schema/schema");
    private final JSONObject baseDefinitionSchemaObject;
    private final SchemaClient downloader;

    BaseValidator(JSONObject definitionSchema, SchemaClient downloader) {
        this.definitionSchemaJsonObject = definitionSchema;
        this.downloader = downloader;
        this.baseDefinitionSchemaObject = BaseValidator.loadResourceAsJSON(BASE_DEFINITION_SCHEMA_PATH);
    }

    @Override
    public void validateObject(JSONObject modelObject, JSONObject definitionSchemaObject) throws ValidationException {
        SchemaLoader.SchemaLoaderBuilder loader = this.getSchemaLoader(definitionSchemaObject);
        try {
            Schema schema = loader.build().load().build();
            schema.validate((Object)modelObject);
        }
        catch (org.everit.json.schema.ValidationException e) {
            throw ValidationException.newScrubbedException(e);
        }
    }

    @Override
    public Schema getListHandlerSchema(JSONObject definitionSchemaObject) throws ValidationException {
        JSONObject handlers = definitionSchemaObject.has("handlers") ? definitionSchemaObject.getJSONObject("handlers") : new JSONObject();
        JSONObject list = handlers.has("list") ? handlers.getJSONObject("list") : new JSONObject();
        JSONObject emptySchema = new JSONObject();
        emptySchema.put("additionalProperties", true);
        JSONObject schemaOverride = list.has("handlerSchema") ? list.getJSONObject("handlerSchema") : emptySchema;
        SchemaLoader.SchemaLoaderBuilder loader = this.getSchemaLoader(definitionSchemaObject, schemaOverride);
        Schema schema = loader.build().load().build();
        return schema;
    }

    @Override
    public void validateObjectByListHandlerSchema(JSONObject modelObject, JSONObject definitionSchemaObject) throws ValidationException {
        Schema schema = this.getListHandlerSchema(definitionSchemaObject);
        schema.validate((Object)modelObject);
    }

    void registerMetaSchema(SchemaLoader.SchemaLoaderBuilder loaderBuilder, JSONObject schema) {
        try {
            if (schema.has(ID_KEY)) {
                String id = schema.getString(ID_KEY);
                if (id.isEmpty()) {
                    throw new ValidationException("Invalid $id value", ID_KEY, "[empty string]");
                }
                URI uri = new URI(id);
                loaderBuilder.registerSchemaByURI(uri, (Object)schema);
            }
        }
        catch (URISyntaxException | JSONException e) {
            throw new ValidationException("Invalid $id value", ID_KEY, (Exception)e);
        }
    }

    SchemaLoader.SchemaLoaderBuilder getSchemaLoader(JSONObject schemaObject) {
        return this.getSchemaLoader().schemaJson(schemaObject);
    }

    SchemaLoader.SchemaLoaderBuilder getSchemaLoader(JSONObject schemaObject, JSONObject handlerSchema) {
        SchemaLoader.SchemaLoaderBuilder schemaLoader = this.getSchemaLoader();
        if (schemaObject.has(SOURCE_URL)) {
            String sourceUrl = schemaObject.getString(SOURCE_URL);
            String schema_file = "resource-schema.json";
            schemaLoader.registerSchemaByURI(BaseValidator.newURI(sourceUrl + "/" + "resource-schema.json"), (Object)schemaObject).resolutionScope(BaseValidator.newURI(sourceUrl + "/"));
        }
        return schemaLoader.schemaJson(handlerSchema);
    }

    SchemaLoader.SchemaLoaderBuilder getSchemaLoader() {
        SchemaLoader.SchemaLoaderBuilder builder = SchemaLoader.builder().draftV7Support().schemaClient(this.downloader);
        builder.registerSchemaByURI(JSON_SCHEMA_URI_HTTP, (Object)this.jsonSchemaObject);
        this.registerMetaSchema(builder, this.baseDefinitionSchemaObject);
        return builder;
    }

    static JSONObject loadResourceAsJSON(String path) {
        return new JSONObject(new JSONTokener(BaseValidator.class.getResourceAsStream(path)));
    }

    static URI newURI(String uri) {
        return new URI(uri);
    }
}

