/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.xray.model.AnnotationValue;
import software.amazon.awssdk.services.xray.model.ServiceId;
import software.amazon.awssdk.services.xray.model.ServiceIdsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ValueWithServiceIds
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ValueWithServiceIds> {
    private static final SdkField<AnnotationValue> ANNOTATION_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ValueWithServiceIds.getter(ValueWithServiceIds::annotationValue)).setter(ValueWithServiceIds.setter(Builder::annotationValue)).constructor(AnnotationValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnnotationValue").build()}).build();
    private static final SdkField<List<ServiceId>> SERVICE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ValueWithServiceIds.getter(ValueWithServiceIds::serviceIds)).setter(ValueWithServiceIds.setter(Builder::serviceIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServiceId::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANNOTATION_VALUE_FIELD, SERVICE_IDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final AnnotationValue annotationValue;
    private final List<ServiceId> serviceIds;

    private ValueWithServiceIds(BuilderImpl builder) {
        this.annotationValue = builder.annotationValue;
        this.serviceIds = builder.serviceIds;
    }

    public AnnotationValue annotationValue() {
        return this.annotationValue;
    }

    public List<ServiceId> serviceIds() {
        return this.serviceIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.annotationValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceIds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValueWithServiceIds)) {
            return false;
        }
        ValueWithServiceIds other = (ValueWithServiceIds)obj;
        return Objects.equals(this.annotationValue(), other.annotationValue()) && Objects.equals(this.serviceIds(), other.serviceIds());
    }

    public String toString() {
        return ToString.builder((String)"ValueWithServiceIds").add("AnnotationValue", (Object)this.annotationValue()).add("ServiceIds", this.serviceIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AnnotationValue": {
                return Optional.ofNullable(clazz.cast(this.annotationValue()));
            }
            case "ServiceIds": {
                return Optional.ofNullable(clazz.cast(this.serviceIds()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ValueWithServiceIds, T> g) {
        return obj -> g.apply((ValueWithServiceIds)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AnnotationValue annotationValue;
        private List<ServiceId> serviceIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ValueWithServiceIds model) {
            this.annotationValue(model.annotationValue);
            this.serviceIds(model.serviceIds);
        }

        public final AnnotationValue.Builder getAnnotationValue() {
            return this.annotationValue != null ? this.annotationValue.toBuilder() : null;
        }

        @Override
        public final Builder annotationValue(AnnotationValue annotationValue) {
            this.annotationValue = annotationValue;
            return this;
        }

        public final void setAnnotationValue(AnnotationValue.BuilderImpl annotationValue) {
            this.annotationValue = annotationValue != null ? annotationValue.build() : null;
        }

        public final Collection<ServiceId.Builder> getServiceIds() {
            return this.serviceIds != null ? (Collection)this.serviceIds.stream().map(ServiceId::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder serviceIds(Collection<ServiceId> serviceIds) {
            this.serviceIds = ServiceIdsCopier.copy(serviceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceIds(ServiceId ... serviceIds) {
            this.serviceIds(Arrays.asList(serviceIds));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceIds(Consumer<ServiceId.Builder> ... serviceIds) {
            this.serviceIds(Stream.of(serviceIds).map(c -> (ServiceId)((ServiceId.Builder)ServiceId.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setServiceIds(Collection<ServiceId.BuilderImpl> serviceIds) {
            this.serviceIds = ServiceIdsCopier.copyFromBuilder(serviceIds);
        }

        public ValueWithServiceIds build() {
            return new ValueWithServiceIds(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ValueWithServiceIds> {
        public Builder annotationValue(AnnotationValue var1);

        default public Builder annotationValue(Consumer<AnnotationValue.Builder> annotationValue) {
            return this.annotationValue((AnnotationValue)((AnnotationValue.Builder)AnnotationValue.builder().applyMutation(annotationValue)).build());
        }

        public Builder serviceIds(Collection<ServiceId> var1);

        public Builder serviceIds(ServiceId ... var1);

        public Builder serviceIds(Consumer<ServiceId.Builder> ... var1);
    }
}

