/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesweb.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.workspacesweb.WorkSpacesWebClient;
import software.amazon.awssdk.services.workspacesweb.internal.UserAgentUtils;
import software.amazon.awssdk.services.workspacesweb.model.ListSessionLoggersRequest;
import software.amazon.awssdk.services.workspacesweb.model.ListSessionLoggersResponse;
import software.amazon.awssdk.services.workspacesweb.model.SessionLoggerSummary;

public class ListSessionLoggersIterable
implements SdkIterable<ListSessionLoggersResponse> {
    private final WorkSpacesWebClient client;
    private final ListSessionLoggersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSessionLoggersIterable(WorkSpacesWebClient client, ListSessionLoggersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSessionLoggersResponseFetcher();
    }

    public Iterator<ListSessionLoggersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SessionLoggerSummary> sessionLoggers() {
        Function<ListSessionLoggersResponse, Iterator> getIterator = response -> {
            if (response != null && response.sessionLoggers() != null) {
                return response.sessionLoggers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSessionLoggersResponseFetcher
    implements SyncPageFetcher<ListSessionLoggersResponse> {
        private ListSessionLoggersResponseFetcher() {
        }

        public boolean hasNextPage(ListSessionLoggersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSessionLoggersResponse nextPage(ListSessionLoggersResponse previousPage) {
            if (previousPage == null) {
                return ListSessionLoggersIterable.this.client.listSessionLoggers(ListSessionLoggersIterable.this.firstRequest);
            }
            return ListSessionLoggersIterable.this.client.listSessionLoggers((ListSessionLoggersRequest)((Object)ListSessionLoggersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

